/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi10a;
import org.scribe.kii.model.Token;

public class EvernoteApi
extends DefaultApi10a {
    private static final String AUTHORIZATION_URL = "https://www.evernote.com/OAuth.action?oauth_token=%s";

    @Override
    @NonNull
    public String getRequestTokenEndpoint() {
        return "https://www.evernote.com/oauth";
    }

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://www.evernote.com/oauth";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    public static class Sandbox
    extends EvernoteApi {
        private static final String SANDBOX_URL = "https://sandbox.evernote.com";

        @Override
        @NonNull
        public String getRequestTokenEndpoint() {
            return "https://sandbox.evernote.com/oauth";
        }

        @Override
        @NonNull
        public String getAccessTokenEndpoint() {
            return "https://sandbox.evernote.com/oauth";
        }

        @Override
        @NonNull
        public String getAuthorizationUrl(@NonNull Token requestToken) {
            return String.format("https://sandbox.evernote.com/OAuth.action?oauth_token=%s", requestToken.getToken());
        }
    }
}

