/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiInstanceManager;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.social.KiiBaseSocialConnect;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnector;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiFacebookConnect
extends KiiBaseSocialConnect
implements KiiSocialConnect {
    public static final String ACCESS_TOKEN = "access_token";
    private static final KiiSocialConnect.SocialNetwork network = KiiSocialConnect.SocialNetwork.FACEBOOK;
    public static final int REQUEST_CODE = 32665;

    private KiiFacebookConnect() {
    }

    static KiiFacebookConnect newInstance() {
        return new KiiFacebookConnect();
    }

    static KiiFacebookConnect newInstance(Bundle b) {
        return new KiiFacebookConnect(b);
    }

    @NonNull
    public static KiiFacebookConnect getInstance() {
        return _KiiInstanceManager.getInstance().getFacebookConnect();
    }

    @Override
    public synchronized void initialize(@Nullable String consumerKey, @Nullable String consumerSecret, @Nullable Bundle options) {
    }

    @Override
    public void logIn(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        this.validateOptions(options);
        JSONObject object = new JSONObject();
        try {
            object.put("accessToken", (Object)options.getString(ACCESS_TOKEN));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.login(object, callback);
    }

    @Override
    public boolean isLinked() {
        if (KiiUser.isLoggedIn()) {
            return KiiUser.getCurrentUser().isLinkedWithSocialProvider(KiiSocialNetworkConnector.Provider.FACEBOOK);
        }
        return false;
    }

    @Override
    public void link(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        this.validateOptions(options);
        JSONObject object = new JSONObject();
        try {
            object.put("accessToken", (Object)options.getString(ACCESS_TOKEN));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.link(object, callback);
    }

    @Override
    public void unlink(@NonNull Activity activity, @Nullable Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        this.unlink(activity, callback);
    }

    @Override
    public void respondAuthOnActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }

    @Override
    @Nullable
    public String getAccessToken() {
        Bundle tokenBundle = this.getAccessTokenBundle();
        if (tokenBundle == null) {
            return null;
        }
        return tokenBundle.getString(ACCESS_TOKEN);
    }

    @Override
    public long getAccessExpires() {
        return 0L;
    }

    private void validateOptions(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Opitons is null or empty");
        }
        String accessToken = bundle.getString(ACCESS_TOKEN);
        if (TextUtils.isEmpty((CharSequence)accessToken)) {
            throw new IllegalArgumentException("Options should contain Facebook access token");
        }
    }

    @Override
    protected void onLoginCompleted(JSONObject requestJson, Bundle tokenBundle) {
        try {
            tokenBundle.putString(ACCESS_TOKEN, requestJson.getString("accessToken"));
            _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.FACEBOOK, tokenBundle);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onLinkCompleted(JSONObject requestJson) {
        try {
            Bundle tokenBundle = new Bundle();
            tokenBundle.putString(ACCESS_TOKEN, requestJson.getString("accessToken"));
            _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.FACEBOOK, tokenBundle);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onPreUnlink(Activity activity) throws IOException, SocialException {
    }

    @Override
    protected String getLoginContentType() {
        return "application/vnd.kii.AuthTokenFacebookRequest+json";
    }

    @Override
    protected String getLinkContentType() {
        return "application/vnd.kii.LinkFacebookRequest+json";
    }

    @Override
    protected String getSocialNetworkName() {
        return "facebook";
    }

    @Override
    protected KiiSocialConnect.SocialNetwork getNetwork() {
        return network;
    }

    @Override
    @Nullable
    public Bundle getAccessTokenBundle() {
        return _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.FACEBOOK);
    }

    @Override
    protected final void onUnlinkCompleted() {
        _KiiUserInternalBridge.clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.FACEBOOK);
    }

    Bundle getParcelableBundle() {
        Bundle b = new Bundle();
        return b;
    }

    void setParcelableBundle(Bundle b) {
    }

    private KiiFacebookConnect(Bundle b) {
    }
}

