/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPOnGoing;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UPSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.UploadFuture;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderSemaphore;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class UPNoEntry
implements UPState {
    public static final String TAG = "NoEntry";

    @Override
    public void transfer(final @NonNull KiiUploaderImpl uploader) throws TerminatedException, SuspendedException, AlreadyStartedException {
        final UploaderLogic cl = uploader.getLogic();
        uploader.setState(new UPOnGoing());
        UploadFuture ufNew = new UploadFuture(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UPNoEntry.this.saveHolderIfNotExist(uploader);
                cl.startUpload(uploader, UPNoEntry.this);
                cl.chunkUpload(uploader, UPNoEntry.this);
                cl.commitUpload(uploader, UPNoEntry.this);
                return null;
            }
        });
        try {
            uploader.getUploadFutureExecutor().executeFuture(ufNew);
            ufNew.get();
            uploader.setState(new UPNoEntry());
        }
        catch (InterruptedException e) {
            throw new SuspendedException("Transfer suspended", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TerminatedException) {
                throw (TerminatedException)cause;
            }
            if (cause instanceof SuspendedException) {
                throw (SuspendedException)cause;
            }
            throw new RuntimeException("Unexpected error", cause);
        }
        catch (CancellationException e) {
            cl.setCancelled();
            if (uploader.cancelledByTermination()) {
                try {
                    uploader.getTransferStore().remove(uploader);
                    uploader.setState(new UPNoEntry());
                    throw new TerminatedException("transfer has terminated");
                }
                catch (StoreException e1) {
                    uploader.setState(new UPSuspended());
                    throw new SuspendedException("transfer is suspended");
                }
            }
            uploader.setState(new UPSuspended());
            throw new SuspendedException("transfer is suspended");
        }
        finally {
            uploader.cancelDone();
        }
    }

    private void saveHolderIfNotExist(KiiUploaderImpl uploader) throws TerminatedException {
        block6: {
            FileHolderInternal holderImpl = uploader.getFileHolderInternal();
            try {
                if (!holderImpl.holderExists()) {
                    try {
                        holderImpl.saveHolder();
                        Uri realUri = holderImpl.getHolderUri();
                        KiiUploaderFactory.onRealUriGenerated(uploader, realUri);
                        UploaderSemaphore.onRealUriGenerated(uploader, realUri);
                        uploader.setHolderUri(realUri);
                        break block6;
                    }
                    catch (AppException e) {
                        uploader.setState(new UPNoEntry());
                        throw new TerminatedException("Failed to create file holder.", e);
                    }
                    catch (IOException e) {
                        uploader.setState(new UPNoEntry());
                        throw new TerminatedException("Failed to create file holder.", e);
                    }
                }
                Uri realUri = holderImpl.getHolderUri();
                KiiUploaderFactory.onRealUriGenerated(uploader, realUri);
                UploaderSemaphore.onRealUriGenerated(uploader, realUri);
                uploader.setHolderUri(realUri);
            }
            catch (InvalidHolderException e) {
                uploader.setState(new UPNoEntry());
                throw new TerminatedException("Destinated holoder does not exists in cloud", e);
            }
        }
    }

    @Override
    public void suspend(@NonNull KiiUploaderImpl uploader) throws NoEntryException {
        uploader.cancelDone();
        throw new NoEntryException("No entry.");
    }

    @Override
    public void terminate(@NonNull KiiUploaderImpl uploader) throws NoEntryException {
        uploader.cancelDone();
        throw new NoEntryException("No entry.");
    }

    @Override
    public void abortGettingUploadId(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws TerminatedException {
        uploader.setState(new UPNoEntry());
        throw new TerminatedException(cause);
    }

    @Override
    public void abortChunkUploading(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws SuspendedException, TerminatedException {
        if (uploader.getLogic().isRecoverble(cause)) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
    }

    @Override
    public void abortCommit(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws TerminatedException, SuspendedException {
        if (uploader.getLogic().isRecoverble(cause)) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
    }

    @Override
    public void abortResumableCheck(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws TerminatedException, SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }
}

