/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.MimeUtil;
import com.kii.cloud.storage.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public class ResumableTransferApi {
    private static final String TAG = "ResumableTransferApi";

    static void startUpload(KiiUploaderImpl uploader) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String ufeUri = Utils.getUFEUri(uploader.getHolderUri()).toString();
        HttpPost request = new HttpPost(Utils.path(ufeUri, "body", "uploads"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.StartObjectBodyUploadrequest+json");
        JSONObject hash = new JSONObject();
        String shash = uploader.getHashGenerator().getHash(uploader.getSourceFile());
        try {
            hash.put("clientHash", (Object)shash);
        }
        catch (JSONException e1) {
            throw new RuntimeException("Unexpected error", e1);
        }
        String entityToCloud = hash.toString();
        Log.v(TAG, "request body: " + hash.toString());
        StringEntity entity = new StringEntity(entityToCloud, "UTF8");
        entity.setContentType("application/json");
        request.setEntity((HttpEntity)entity);
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject respObj = new JSONObject(res.body);
            String uploadId = respObj.getString("uploadID");
            uploader.setUploadId(uploadId);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long upload(KiiUploaderImpl uploader) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        long completedInBytes = uploader.getCompletedInBytes();
        long totalInBytes = uploader.getTotalInBytes();
        Log.v(TAG, "completedBytes:" + completedInBytes + " total:" + totalInBytes);
        File file = uploader.getSourceFile();
        if (!file.exists()) {
            throw new FileNotFoundException("source file does not exist");
        }
        String mimeType = MimeUtil.getInfoByFile(file);
        int chunkSize = uploader.getChunkSize();
        BufferedInputStream bif = null;
        String tempFilename = "temp" + System.currentTimeMillis();
        FilterOutputStream bos = null;
        try {
            int readlen;
            FileOutputStream fos = uploader.getContext().openFileOutput(tempFilename, 0);
            bos = new BufferedOutputStream(fos);
            bif = new BufferedInputStream(new FileInputStream(file));
            bif.skip(completedInBytes);
            byte[] buffer = new byte[8192];
            int readTotal = 0;
            while (readTotal < chunkSize && (readlen = bif.read(buffer)) >= 0) {
                Log.v(TAG, "readlen: " + readlen);
                if ((readTotal += readlen) >= chunkSize) {
                    ((BufferedOutputStream)bos).write(buffer, 0, readlen - (readTotal - chunkSize));
                    readTotal = chunkSize;
                    continue;
                }
                ((BufferedOutputStream)bos).write(buffer, 0, readlen);
            }
            ((BufferedOutputStream)bos).flush();
            Log.v(TAG, "read total :" + readTotal);
            if (readTotal <= 0) {
                throw new IOException("Can not read content.");
            }
            String ufeUri = Utils.getUFEUri(uploader.getHolderUri()).toString();
            HttpPut request = new HttpPut(Utils.path(ufeUri, "body", "uploads", uploader.getUploadId(), "data"));
            KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
            request.setHeader("X-Kii-AppID", Kii.getAppId());
            request.setHeader("X-Kii-AppKey", Kii.getAppKey());
            request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
            request.setHeader("Content-Type", mimeType);
            request.setHeader("Content-Range", ResumableTransferApi.getContentRange(completedInBytes, totalInBytes, readTotal));
            String hash = uploader.getHashGenerator().getHash(uploader.getSourceFile());
            request.setHeader("if-match", hash);
            FileEntity entity = new FileEntity(new File(uploader.getContext().getFilesDir(), tempFilename), mimeType);
            entity.setContentType(mimeType);
            request.setEntity((HttpEntity)entity);
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            long l = completedInBytes += (long)readTotal;
            return l;
        }
        finally {
            try {
                if (bif != null) {
                    bif.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
            uploader.getContext().deleteFile(tempFilename);
        }
    }

    static void commit(KiiUploaderImpl uploader) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String ufeUri = Utils.getUFEUri(uploader.getHolderUri()).toString();
        HttpPost request = new HttpPost(Utils.path(ufeUri, "body", "uploads", uploader.getUploadId(), "status", "committed"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    static String getHash(KiiUploaderImpl uploader) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String ufeUri = Utils.getUFEUri(uploader.getHolderUri()).toString();
        HttpHead request = new HttpHead(Utils.path(ufeUri, "body", "uploads", uploader.getUploadId()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        return res.eTag;
    }

    private static String getContentRange(long completedInBytes, long totalInBytes, int readInBytes) {
        return "bytes=" + completedInBytes + "-" + (completedInBytes + (long)readInBytes - 1L) + "/" + totalInBytes;
    }

    private static String getDownloadRange(long completedInBytes, int readInBytes) {
        return "bytes=" + completedInBytes + "-" + (completedInBytes + (long)readInBytes - 1L);
    }

    static long download(KiiDownloaderImpl downloader, DownloaderCommonLogic logic) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException, FileModifiedException {
        int chunkSize;
        long completedInBytes = downloader.getCompletedInBytes();
        long totalInBytes = downloader.getTotalInBytes();
        long remain = totalInBytes - completedInBytes;
        int bytesToReceive = (int)(remain < (long)(chunkSize = downloader.getChunkSize()) ? remain : (long)chunkSize);
        Log.v(TAG, "bytesToReceive: " + bytesToReceive);
        String ufeUri = Utils.getUFEUri(downloader.getHolderUri()).toString();
        HttpGet request = new HttpGet(Utils.path(ufeUri, "body"));
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        if (downloader.getEtag() != null) {
            request.setHeader("If-Match", downloader.getEtag());
        }
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("Range", ResumableTransferApi.getDownloadRange(completedInBytes, bytesToReceive));
        ApiResponse response = KiiCloudEngine.getInstance().downloadFileByChunkRequest(downloader.getDestFile().getAbsolutePath(), (HttpUriRequest)request, completedInBytes, logic);
        String eTag = response.eTag;
        if (!logic.cancelled()) {
            downloader.setEtag(eTag);
        }
        return completedInBytes + (long)bytesToReceive;
    }

    static String getBodyEtag(KiiDownloaderImpl downloader) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String ufeUri = Utils.getUFEUri(downloader.getHolderUri()).toString();
        HttpHead request = new HttpHead(Utils.path(ufeUri, "body"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        return res.eTag;
    }

    static long getBodyLengthInBytes(KiiDownloaderImpl downloader) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        String ufeUri = Utils.getUFEUri(downloader.getHolderUri()).toString();
        HttpHead request = new HttpHead(Utils.path(ufeUri, "body"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        long length = Long.parseLong(response.contentLength);
        return length;
    }
}

