/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class RTransferInfoStoreDB {
    MyDBOpenHelper helper;
    SQLiteDatabase db;
    static RTransferInfoStoreDB INSTANCE = new RTransferInfoStoreDB();
    public static final int SCHEME_VERSION = 3;

    private RTransferInfoStoreDB() {
    }

    public static RTransferInfoStoreDB getInstance() {
        return INSTANCE;
    }

    public synchronized void init(@NonNull Context ctx) {
        if (this.db == null) {
            this.db = this.getWritableDatabase(ctx);
        }
    }

    public long insert(@NonNull ContentValues cv) {
        return this.db.insert("rtransfer_table", null, cv);
    }

    public int update(@NonNull ContentValues cv, @Nullable String whereClause, @Nullable String[] whereArgs) {
        return this.db.update("rtransfer_table", cv, whereClause, whereArgs);
    }

    @NonNull
    public Cursor query(@Nullable String selection, @Nullable String[] selectionArgs) {
        return this.db.query("rtransfer_table", null, selection, selectionArgs, null, null, null);
    }

    public int delete(@Nullable String whereClause, @Nullable String[] whereArgs) {
        return this.db.delete("rtransfer_table", whereClause, whereArgs);
    }

    synchronized SQLiteDatabase getWritableDatabase(Context context) {
        if (this.helper == null) {
            this.helper = new MyDBOpenHelper(context);
        }
        return this.helper.getWritableDatabase();
    }

    public class MyDBOpenHelper
    extends SQLiteOpenHelper {
        public static final String DBNAME = "rtransferdb";
        public static final String RTRANSFER_TABLE = "rtransfer_table";
        private static final String CREATE_TABLE_SQL_V3 = "CREATE TABLE rtransfer_table(_id INTEGER PRIMARY KEY AUTOINCREMENT, holder_uri TEXT, source_file_path TEXT, file_modified_time INTEGER, direction INTEGER, completed_size INTEGER, total_size INTEGER, upload_id TEXT, etag TEXT, dest_file_path TEXT, initiator_uri TEXT,  UNIQUE  ( holder_uri , direction , source_file_path , dest_file_path )  );";
        private static final String DROP_TABLE_SQL = "DROP TABLE IF EXISTS rtransfer_table";

        public MyDBOpenHelper(Context context) {
            super(context, DBNAME, null, 3);
        }

        public void onCreate(@NonNull SQLiteDatabase db) {
            this.createTable(db);
        }

        public void onUpgrade(@NonNull SQLiteDatabase db, int oldVersion, int newVersion) {
            this.dropTable(db);
            this.createTable(db);
        }

        private void createTable(SQLiteDatabase db) {
            db.execSQL(CREATE_TABLE_SQL_V3);
        }

        private void dropTable(SQLiteDatabase db) {
            db.execSQL(DROP_TABLE_SQL);
        }
    }

    public class Direction {
        public static final int UP = 0;
        public static final int DOWN = 1;
    }

    public class Col {
        public static final String TRANSFER_ID = "_id";
        public static final String HOLDER_URI = "holder_uri";
        public static final String SOURCE_FILE_PATH = "source_file_path";
        public static final String FILE_MODIFIED_TIME = "file_modified_time";
        public static final String DIRECTION = "direction";
        public static final String COMPLETED_SIZE = "completed_size";
        public static final String TOTAL_SIZE = "total_size";
        public static final String UPLOAD_ID = "upload_id";
        public static final String ETAG = "etag";
        public static final String DEST_FILE_PATH = "dest_file_path";
        public static final String INITIATOR_URI = "initiator_uri";
    }
}

