/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.KiiInternalUtil;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import java.io.IOException;

public class KiiCloudFileHolder
implements FileHolderInternal {
    FileHolder holder;

    KiiCloudFileHolder(FileHolder holder) {
        this.holder = holder;
    }

    @Override
    @Nullable
    public Uri getHolderUri() throws InvalidHolderException {
        Uri uri = null;
        try {
            if (!(this.holder instanceof KiiObject)) {
                throw new RuntimeException("Unexpected error.");
            }
            uri = KiiInternalUtil.toUri2((KiiObject)this.holder);
        }
        catch (IllegalStateException e) {
            throw new InvalidHolderException("The holder has deleted.");
        }
        return uri;
    }

    @Override
    public boolean holderExists() throws InvalidHolderException {
        try {
            if (this.holder instanceof KiiObject) {
                KiiObject ko = (KiiObject)this.holder;
                Uri uri = KiiInternalUtil.toUri2(ko);
                return uri != null;
            }
            throw new RuntimeException("Unexpected error.");
        }
        catch (IllegalStateException e) {
            throw new InvalidHolderException("The holder has deleted.");
        }
    }

    @Override
    public void saveHolder() throws AppException, IOException {
        if (!(this.holder instanceof KiiObject)) {
            throw new RuntimeException("Unexpected error.");
        }
        KiiObject ko = (KiiObject)this.holder;
        ko.save();
    }

    @Override
    @Nullable
    public FileHolder getFileHolder() {
        return this.holder;
    }
}

