/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.query;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiThingQuery {
    private final KiiUser owner;
    private final List<KiiGroup> groups;
    private String thingType;
    private int limit;
    private String nextPaginationKey;

    public KiiThingQuery(@Nullable KiiUser owner, @Nullable List<KiiGroup> groups) {
        if (owner == null && (groups == null || groups.size() == 0)) {
            throw new IllegalArgumentException("Both the owner and groups parameter are optional, but at least one of them must be supplied.");
        }
        this.owner = owner;
        this.groups = groups;
    }

    public KiiThingQuery(@NonNull KiiThingQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query is null");
        }
        this.owner = query.owner != null ? KiiUser.userWithID(query.owner.getID()) : null;
        if (query.groups != null) {
            this.groups = new ArrayList<KiiGroup>();
            for (KiiGroup group : query.groups) {
                this.groups.add(KiiGroup.groupWithID(group.getID()));
            }
        } else {
            this.groups = null;
        }
        this.limit = query.limit;
        this.thingType = query.thingType;
    }

    public void setThingType(String thingType) {
        this.thingType = thingType;
    }

    public void setLimit(int limit) {
        this.limit = limit > 0 ? limit : 0;
    }

    void setNextPaginationKey(String nextPaginationKey) {
        this.nextPaginationKey = nextPaginationKey;
    }

    JSONObject toJson() {
        try {
            JSONObject query = new JSONObject();
            JSONObject clause = new JSONObject();
            JSONObject userOwnerClause = null;
            JSONArray groupOwnerClauses = null;
            int ownerClausesCount = 0;
            if (this.owner != null) {
                userOwnerClause = new JSONObject();
                userOwnerClause.put("type", (Object)"contains");
                userOwnerClause.put("field", (Object)"userOwners");
                userOwnerClause.put("value", (Object)this.owner.getID());
                ++ownerClausesCount;
            }
            if (this.groups != null && this.groups.size() > 0) {
                groupOwnerClauses = new JSONArray();
                for (int i = 0; i < this.groups.size(); ++i) {
                    JSONObject groupOwnerClause = new JSONObject();
                    groupOwnerClause.put("type", (Object)"contains");
                    groupOwnerClause.put("field", (Object)"groupOwners");
                    groupOwnerClause.put("value", (Object)this.groups.get(i).getID());
                    groupOwnerClauses.put((Object)groupOwnerClause);
                    ++ownerClausesCount;
                }
            }
            JSONObject ownerClause = null;
            if (ownerClausesCount == 0) {
                throw new IllegalArgumentException("Query clause must include the 'contains' clause.");
            }
            if (ownerClausesCount == 1) {
                ownerClause = userOwnerClause != null ? userOwnerClause : groupOwnerClauses.getJSONObject(0);
            } else {
                ownerClause = new JSONObject();
                ownerClause.put("type", (Object)"or");
                JSONArray clauses = new JSONArray();
                if (userOwnerClause != null) {
                    clauses.put((Object)userOwnerClause);
                }
                for (int i = 0; i < groupOwnerClauses.length(); ++i) {
                    clauses.put((Object)groupOwnerClauses.getJSONObject(i));
                }
                ownerClause.put("clauses", (Object)clauses);
            }
            if (TextUtils.isEmpty((CharSequence)this.thingType)) {
                clause.put("clause", (Object)ownerClause);
            } else {
                JSONObject thingTypeClause = new JSONObject();
                thingTypeClause.put("type", (Object)"eq");
                thingTypeClause.put("field", (Object)"_thingType");
                thingTypeClause.put("value", (Object)this.thingType);
                JSONArray clauses = new JSONArray();
                clauses.put((Object)ownerClause);
                clauses.put((Object)thingTypeClause);
                JSONObject andClause = new JSONObject();
                andClause.put("type", (Object)"and");
                andClause.put("clauses", (Object)clauses);
                clause.put("clause", (Object)andClause);
            }
            query.put("thingQuery", (Object)clause);
            if (!TextUtils.isEmpty((CharSequence)this.nextPaginationKey)) {
                query.put("paginationKey", (Object)this.nextPaginationKey);
            }
            if (this.limit > 0) {
                query.put("bestEffortLimit", this.limit);
            }
            return query;
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error!", e);
        }
    }

    @NonNull
    public String toString() {
        return this.toJson().toString();
    }
}

