/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.query;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiBaseBucket;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.callback.KiiQueryCallBack;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.query.KiiQuery;
import java.io.IOException;
import java.util.List;

public class KiiQueryResult<T> {
    private KiiQuery mNextQuery;
    private List<T> mResult;
    private KiiBaseBucket mBucket;

    public KiiQueryResult(@Nullable KiiQuery query, @NonNull List<T> result, @Nullable String paginationKey, @NonNull KiiBaseBucket bucket, boolean trashed) {
        this.mResult = result;
        if (TextUtils.isEmpty((CharSequence)paginationKey)) {
            this.mNextQuery = null;
        } else {
            this.mNextQuery = KiiQuery.copy(query);
            this.mNextQuery.setNextPaginationKey(paginationKey);
        }
        this.mBucket = bucket;
    }

    public KiiQueryResult(@Nullable KiiQuery query, @NonNull List<T> result, @Nullable String paginationKey, @NonNull KiiBaseBucket bucket) {
        this.mResult = result;
        if (TextUtils.isEmpty((CharSequence)paginationKey)) {
            this.mNextQuery = null;
        } else {
            this.mNextQuery = KiiQuery.copy(query);
            this.mNextQuery.setNextPaginationKey(paginationKey);
        }
        this.mBucket = bucket;
    }

    @NonNull
    public List<T> getResult() {
        return this.mResult;
    }

    public boolean hasNext() {
        return this.mNextQuery != null;
    }

    @Nullable
    public KiiQuery getNextKiiQuery() {
        return this.mNextQuery;
    }

    @NonNull
    public KiiQueryResult<T> getNextQueryResult() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (!this.hasNext()) {
            throw new IllegalStateException("End of the page. no more results.");
        }
        KiiQuery query = this.getNextKiiQuery();
        if (this.mBucket instanceof KiiBucket) {
            KiiBucket bucket = (KiiBucket)this.mBucket;
            return bucket.query(query);
        }
        throw new RuntimeException("Unexpected error! " + this.mBucket.getClass().getCanonicalName());
    }

    public int getNextQueryResult(@NonNull KiiQueryCallBack<T> callback) {
        if (!this.hasNext()) {
            throw new IllegalStateException("End of the page. no more results.");
        }
        KiiQuery query = this.getNextKiiQuery();
        if (this.mBucket instanceof KiiBucket) {
            KiiBucket bucket = (KiiBucket)this.mBucket;
            return bucket.query(callback, query);
        }
        throw new RuntimeException("Unexpected error! " + this.mBucket.getClass().getCanonicalName());
    }
}

