/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.photocolle;

import android.content.Context;
import android.support.annotation.NonNull;
import com.kii.cloud.storage.photocolle.PhotoColleRTransferManager;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.utils.Utils;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.PhotoColle;
import com.kii.sdk.photocolle._InternalPhotoColleSDKSetter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class KiiCloudPhotoColle
extends PhotoColle {
    private static String ACCESS_URL = "https://api-photocolle-jp.kii.com";

    KiiCloudPhotoColle(Context androidContext, AuthenticationContext authenticationContext) throws ParameterException {
        super(androidContext, authenticationContext);
        try {
            _InternalPhotoColleSDKSetter.setBaseUrl((PhotoColle)this, (URL)new URL(KiiCloudPhotoColle.getBaseUrl() + "/app/dcm_elb"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public KiiUploader uploader(@NonNull Context context, @NonNull File source) {
        if (context == null || source == null) {
            throw new IllegalArgumentException("Context or File is null");
        }
        Utils.checkInitialize(true);
        return KiiUploaderFactory.newPhotoColleUploader(context, source);
    }

    @NonNull
    public PhotoColleRTransferManager getTransferManager() {
        return new PhotoColleRTransferManager();
    }

    static String getBaseUrl() {
        return ACCESS_URL;
    }
}

