/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.engine;

import android.support.annotation.NonNull;
import com.kii.cloud.okhttp.KiiHttpClient;
import com.kii.cloud.storage.engine._HttpClientFactoryOptions;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.apache.OkApacheClient;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;

public class _HttpClientFactory {
    private static final String TAG = "_HttpClientFactory";
    private static HashMap<_HttpClientFactoryOptions, HttpClient> CLIENTS = new HashMap();

    @NonNull
    public synchronized HttpClient createClient() {
        _HttpClientFactoryOptions options = new _HttpClientFactoryOptions();
        return this.createClient(options);
    }

    @NonNull
    public synchronized HttpClient createClient(_HttpClientFactoryOptions options) {
        HttpClient httpClient = CLIENTS.get(options);
        if (httpClient != null) {
            return httpClient;
        }
        OkHttpClient client = new OkHttpClient();
        client.setRetryOnConnectionFailure(options.retryOnConnectionFailure());
        OkApacheClient apacheClient = new OkApacheClient(client);
        client.setConnectTimeout(30L, TimeUnit.SECONDS);
        client.setReadTimeout(30L, TimeUnit.SECONDS);
        client.setWriteTimeout(30L, TimeUnit.SECONDS);
        httpClient = new KiiHttpClient(apacheClient);
        CLIENTS.put(options, httpClient);
        return httpClient;
    }
}

