/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.Nullable;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

class UserCredentials {
    private String mAppId;
    private String mBaseURL;
    private String mUserId;
    private String mUsername;
    private String mEmailAddress;
    private boolean mEmailAddressVerified;
    private String mPendingEmailAddress;
    private String mPhoneNumber;
    private boolean mPhoneNumberVerified;
    private String mPendingPhoneNumber;
    private String mCountry;
    private String mDisplayName;
    private String mAccessToken;
    private String mRefreshToken;
    private long mExpiresAt;

    private UserCredentials() {
    }

    static UserCredentials fromKiiUser(KiiUser user) {
        UserCredentials u = new UserCredentials();
        u.mAppId = Kii.getAppId();
        u.mBaseURL = Kii.getBaseURL();
        u.mUserId = user.getID();
        u.mUsername = user.getUsername();
        u.mEmailAddress = user.getEmail();
        u.mEmailAddressVerified = user.isEmailVerified();
        u.mPendingEmailAddress = user.getPendingEmail();
        u.mPhoneNumber = user.getPhone();
        u.mPhoneNumberVerified = user.isPhoneVerified();
        u.mPendingPhoneNumber = user.getPendingPhone();
        u.mCountry = user.getCountry();
        u.mDisplayName = user.getDisplayname();
        u.mAccessToken = user.getAccessToken();
        u.mRefreshToken = user.getRefreshToken();
        u.mExpiresAt = user.getAccessTokenExpiresAt();
        return u;
    }

    static UserCredentials fromJsonString(String jsonString) {
        UserCredentials u = null;
        if (!Utils.isEmpty(jsonString)) {
            try {
                JSONObject json = new JSONObject(jsonString);
                u = new UserCredentials();
                u.mAppId = json.optString("app_id", null);
                u.mBaseURL = json.optString("base_url", null);
                u.mUserId = json.optString("user_id", null);
                u.mUsername = json.optString("username", null);
                u.mEmailAddress = json.optString("mail", null);
                u.mEmailAddressVerified = json.optBoolean("emailAddressVerified", false);
                u.mPendingEmailAddress = json.optString("pendingEmailAddress", null);
                u.mPhoneNumber = json.optString("phone", null);
                u.mPhoneNumberVerified = json.optBoolean("phoneNumberVerified", false);
                u.mPendingPhoneNumber = json.optString("pendingPhoneNumber", null);
                u.mCountry = json.optString("country", null);
                u.mDisplayName = json.optString("display_name", null);
                u.mAccessToken = json.optString("access_token", null);
                u.mRefreshToken = json.optString("refresh_token", null);
                u.mExpiresAt = json.optLong("expires_at");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return u;
    }

    boolean isValid() {
        return this.mAppId != null && this.mUserId != null && this.mBaseURL != null && this.mAccessToken != null;
    }

    String toJsonString() {
        JSONObject json = new JSONObject();
        try {
            if (!Utils.isEmpty(this.mAppId)) {
                json.put("app_id", (Object)this.mAppId);
            }
            if (!Utils.isEmpty(this.mBaseURL)) {
                json.put("base_url", (Object)this.mBaseURL);
            }
            if (!Utils.isEmpty(this.mUserId)) {
                json.put("user_id", (Object)this.mUserId);
            }
            if (!Utils.isEmpty(this.mUsername)) {
                json.put("username", (Object)this.mUsername);
            }
            if (!Utils.isEmpty(this.mEmailAddress)) {
                json.put("mail", (Object)this.mEmailAddress);
            }
            json.put("emailAddressVerified", this.mEmailAddressVerified);
            if (!Utils.isEmpty(this.mPendingEmailAddress)) {
                json.put("pendingEmailAddress", (Object)this.mPendingEmailAddress);
            }
            if (!Utils.isEmpty(this.mPhoneNumber)) {
                json.put("phone", (Object)this.mPhoneNumber);
            }
            json.put("phoneNumberVerified", this.mPhoneNumberVerified);
            if (!Utils.isEmpty(this.mPendingPhoneNumber)) {
                json.put("pendingPhoneNumber", (Object)this.mPendingPhoneNumber);
            }
            if (!Utils.isEmpty(this.mCountry)) {
                json.put("country", (Object)this.mCountry);
            }
            if (!Utils.isEmpty(this.mDisplayName)) {
                json.put("display_name", (Object)this.mDisplayName);
            }
            if (!Utils.isEmpty(this.mAccessToken)) {
                json.put("access_token", (Object)this.mAccessToken);
            }
            if (!Utils.isEmpty(this.mRefreshToken)) {
                json.put("refresh_token", (Object)this.mRefreshToken);
            }
            json.put("expires_at", this.mExpiresAt);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json.toString();
    }

    @Nullable
    public String getAppId() {
        return this.mAppId;
    }

    @Nullable
    public String getBaseURL() {
        return this.mBaseURL;
    }

    @Nullable
    public String getUserId() {
        return this.mUserId;
    }

    @Nullable
    public String getUsername() {
        return this.mUsername;
    }

    @Nullable
    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public boolean getEmailAddressVerifeid() {
        return this.mEmailAddressVerified;
    }

    @Nullable
    public String getPendingEmailAddress() {
        return this.mPendingEmailAddress;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.mPhoneNumber;
    }

    public boolean getPhoneNumberVerified() {
        return this.mPhoneNumberVerified;
    }

    @Nullable
    public String getPendingPhoneNumber() {
        return this.mPendingPhoneNumber;
    }

    @Nullable
    public String getCountry() {
        return this.mCountry;
    }

    @Nullable
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Nullable
    public String getAccessToken() {
        return this.mAccessToken;
    }

    @Nullable
    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public long getExpiresAt() {
        return this.mExpiresAt;
    }
}

