/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.utils.Utils;
import java.util.Locale;

public class LocaleContainer {
    private final Locale locale;
    private final String localeString;

    public static LocaleContainer fromBcp47Tag(String bcp47Tag) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Locale locale = Locale.forLanguageTag(bcp47Tag);
                return new LocaleContainer(locale, bcp47Tag);
            }
            String[] subtags = bcp47Tag.split("-");
            String language = null;
            String script = null;
            String region = null;
            String variant = null;
            language = subtags[0];
            if (subtags.length > 1) {
                if (LocaleContainer.isScript(subtags[1])) {
                    script = subtags[1];
                } else if (LocaleContainer.isRegion(subtags[1])) {
                    region = subtags[1];
                } else if (LocaleContainer.isVariant(subtags[1])) {
                    variant = subtags[1];
                }
            }
            if (subtags.length > 2) {
                if (LocaleContainer.isRegion(subtags[2])) {
                    region = subtags[2];
                } else if (LocaleContainer.isVariant(subtags[2])) {
                    variant = subtags[2];
                }
            }
            if (subtags.length > 3 && LocaleContainer.isVariant(subtags[3])) {
                variant = subtags[3];
            }
            if ("he".equals(language)) {
                language = "iw";
            } else if ("id".equals(language)) {
                language = "in";
            } else if ("yi".equals(language)) {
                language = "ji";
            }
            Locale locale = null;
            locale = variant != null ? new Locale(language, region, variant) : (region != null ? new Locale(language, region) : new Locale(language));
            return new LocaleContainer(locale, bcp47Tag);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static String toBcp47Tag(Locale locale) {
        if (Build.VERSION.SDK_INT >= 21) {
            return locale.toLanguageTag();
        }
        String[] localeStrings = locale.toString().split("_");
        if (localeStrings[0].isEmpty() || !localeStrings[0].matches("\\p{Alpha}{2,8}")) {
            localeStrings[0] = "und";
        } else if (localeStrings[0].equals("iw")) {
            localeStrings[0] = "he";
        } else if (localeStrings[0].equals("in")) {
            localeStrings[0] = "id";
        } else if (localeStrings[0].equals("ji")) {
            localeStrings[0] = "yi";
        }
        block5: for (int i = 0; i < localeStrings.length; ++i) {
            switch (i) {
                case 0: {
                    if (LocaleContainer.isLanguage(localeStrings[i])) continue block5;
                    return locale.toString();
                }
                case 1: {
                    if (LocaleContainer.isScript(localeStrings[i]) || LocaleContainer.isRegion(localeStrings[i])) continue block5;
                    return locale.toString();
                }
                case 2: {
                    if (LocaleContainer.isRegion(localeStrings[i]) || LocaleContainer.isVariant(localeStrings[i])) continue block5;
                    return locale.toString();
                }
            }
        }
        StringBuilder bcp47Tag = new StringBuilder();
        for (String subtag : localeStrings) {
            if (bcp47Tag.length() > 0) {
                bcp47Tag.append("-");
            }
            bcp47Tag.append(subtag);
        }
        return bcp47Tag.toString();
    }

    public LocaleContainer() {
        this(Locale.getDefault());
    }

    public LocaleContainer(Locale locale) {
        this(locale, null);
    }

    private LocaleContainer(Locale locale, String localeString) {
        this.locale = locale;
        this.localeString = localeString;
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    @Nullable
    public String getLocaleString() {
        return this.localeString;
    }

    public String toString() {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.locale.toLanguageTag();
        }
        if (!Utils.isEmpty(this.localeString)) {
            return this.localeString;
        }
        return LocaleContainer.toBcp47Tag(this.locale);
    }

    static boolean isLanguage(String s) {
        int len = s.length();
        return len >= 2 && len <= 8 && Utils.isAlphaString(s);
    }

    static boolean isScript(String s) {
        return s.length() == 4 && Utils.isAlphaString(s);
    }

    static boolean isRegion(String s) {
        return s.length() == 2 && Utils.isAlphaString(s) || s.length() == 3 && Utils.isNumericString(s);
    }

    static boolean isVariant(String s) {
        int len = s.length();
        if (len >= 5 && len <= 8) {
            return Utils.isAlphaNumericString(s);
        }
        if (len == 4) {
            return Utils.isNumeric(s.charAt(0)) && Utils.isAlphaNumeric(s.charAt(1)) && Utils.isAlphaNumeric(s.charAt(2)) && Utils.isAlphaNumeric(s.charAt(3));
        }
        return false;
    }
}

