/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiTopicTask;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiACL;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiPushMessage;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiSubscribable;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiTopicCallBack;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class KiiTopic
implements KiiSubscribable {
    KiiScope scope;
    String name;

    KiiTopic(KiiScope scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    @WorkerThread
    public boolean exists() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String topicUri = this.getUFEUri();
        HttpHead request = new HttpHead(topicUri);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        try {
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public void exists(final @NonNull KiiCallback<Boolean> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private Boolean existence = null;

            @Override
            public void run() {
                try {
                    this.existence = KiiTopic.this.exists();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.existence, this.getException());
            }
        });
    }

    @WorkerThread
    public void save() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        if (this.scope == null) {
            throw new UnsupportedOperationException("Can not create app scope topic from client SDK. To create, use REST api with App Admin token.");
        }
        String ufeUri = this.getUFEUri();
        HttpPut request = new HttpPut(ufeUri);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int save(@NonNull KiiTopicCallBack callback) {
        KiiTopicTask topicTask = new KiiTopicTask(KiiTopicTask.TaskType.SAVE, this, callback, null);
        KiiTaskExecutor.getInstance().execute(topicTask);
        return topicTask.getTaskId();
    }

    @WorkerThread
    public void sendMessage(@NonNull KiiPushMessage message) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        String topicUri = this.getUFEUri();
        String reqUri = Utils.path(topicUri, "push", "messages");
        HttpPost request = new HttpPost(reqUri);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        StringEntity ent = new StringEntity(message.toJSON().toString(), "UTF-8");
        ent.setContentType("application/vnd.kii.SendPushMessageRequest+json");
        request.setEntity((HttpEntity)ent);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int sendMessage(@NonNull KiiPushMessage message, @NonNull KiiTopicCallBack callback) {
        KiiTopicTask topicTask = new KiiTopicTask(KiiTopicTask.TaskType.SENDMESSAGE, this, callback, message);
        KiiTaskExecutor.getInstance().execute(topicTask);
        return topicTask.getTaskId();
    }

    String getUFEUri() {
        Utils.checkInitialize(false);
        String path = null;
        if (this.scope == null) {
            path = Utils.path("apps", Kii.getAppId(), "topics", this.name);
        } else if (this.scope instanceof KiiUser) {
            KiiUser user = (KiiUser)this.scope;
            path = Utils.path("apps", Kii.getAppId(), "users", user.getID(), "topics", this.name);
        } else if (this.scope instanceof KiiGroup) {
            KiiGroup group = (KiiGroup)this.scope;
            path = Utils.path("apps", Kii.getAppId(), "groups", group.getID(), "topics", this.name);
        } else if (this.scope instanceof KiiThing) {
            KiiThing thing = (KiiThing)this.scope;
            path = Utils.path("apps", Kii.getAppId(), "things", thing.getID(), "topics", this.name);
        }
        path = Utils.path(Kii.getBaseURL(), path);
        return path;
    }

    @WorkerThread
    public void delete() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        Utils.checkInitialize(true);
        if (this.scope == null) {
            throw new UnsupportedOperationException("Can not delete app scope topic from client SDK. To delete, use REST api with App Admin token.");
        }
        String deleteUrl = this.getUFEUri();
        HttpDelete request = new HttpDelete(deleteUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int delete(@NonNull KiiTopicCallBack callback) {
        KiiTopicTask topicTask = new KiiTopicTask(KiiTopicTask.TaskType.DELETE, this, callback, null);
        KiiTaskExecutor.getInstance().execute(topicTask);
        return topicTask.getTaskId();
    }

    public KiiACL acl() {
        return new KiiACL(this);
    }

    public String getName() {
        return this.name;
    }
}

