/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.kii.cloud.async.executor.KiiServerCodeEntryTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiServerCodeEntryArgument;
import com.kii.cloud.storage.KiiServerCodeEntryCallback;
import com.kii.cloud.storage.KiiServerCodeExecResult;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiServerCodeEntry {
    private String entryName;
    private String version;
    private static final String SERVER_CODE_ENTRY_PATTERN_REX = "[a-zA-Z][_a-zA-Z0-9]*$";

    KiiServerCodeEntry(String entryName) {
        this.entryName = entryName;
    }

    KiiServerCodeEntry(String entryName, String version) {
        this.entryName = entryName;
        this.version = version;
    }

    @NonNull
    public String getEntryName() {
        return this.entryName;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @WorkerThread
    @NonNull
    public KiiServerCodeExecResult execute(@Nullable KiiServerCodeEntryArgument argument) throws BadRequestException, UnauthorizedException, ForbiddenException, UndefinedException, IOException, NotFoundException, ConflictException {
        Utils.checkInitialize(false);
        if (argument == null) {
            argument = KiiServerCodeEntryArgument.newArgument(new JSONObject());
        }
        String versionName = this.version == null ? "current" : this.version.toString();
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "server-code", "versions", versionName, this.entryName);
        HttpPost request = new HttpPost(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        String entityToCloud = argument.toJSON().toString();
        StringEntity entity = new StringEntity(entityToCloud, "UTF8");
        entity.setContentType("application/json");
        request.setEntity((HttpEntity)entity);
        ApiResponse res = null;
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject retJson = new JSONObject(res.body);
            int stepCount = Integer.parseInt(Utils.getHeaderValueByName(res.headers, "X-Step-count"));
            return new KiiServerCodeExecResult(retJson, stepCount);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void execute(@Nullable KiiServerCodeEntryArgument argument, @Nullable KiiServerCodeEntryCallback callback) {
        Utils.checkInitialize(false);
        KiiServerCodeEntryTask task = new KiiServerCodeEntryTask(KiiServerCodeEntryTask.TaskType.EXECUTE, callback, this, argument);
        KiiTaskExecutor.getInstance().execute(task);
    }

    static boolean isValidEntryName(String name) {
        return Pattern.matches(SERVER_CODE_ENTRY_PATTERN_REX, name);
    }
}

