/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.kii.cloud.async.executor.KiiPushSubscriptionTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiSubscribable;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiPushCallBack;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class KiiPushSubscription {
    private final KiiUser user;
    private final KiiThing thing;

    KiiPushSubscription(KiiUser user) {
        if (user == null) {
            throw new IllegalArgumentException("user must not be null");
        }
        this.user = user;
        this.thing = null;
    }

    KiiPushSubscription(KiiThing thing) {
        if (thing == null) {
            throw new IllegalArgumentException("thing must not be null");
        }
        this.user = null;
        this.thing = thing;
    }

    @WorkerThread
    public void subscribeBucket(@NonNull KiiBucket bucket) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket must not be  null.");
        }
        Utils.checkInitialize(true);
        String bucketUrl = bucket.getBucketUrl();
        String putUrl = Utils.path(bucketUrl, "filters", "all", "push", "subscriptions", this.getTargetPath());
        HttpPut request = new HttpPut(putUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int subscribeBucket(@NonNull KiiBucket bucket, @NonNull KiiPushCallBack callback) {
        KiiPushSubscriptionTask task = new KiiPushSubscriptionTask(KiiPushSubscriptionTask.TaskType.SUBSCRIBE_BUCKET, this, bucket, null, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    @WorkerThread
    public void unsubscribeBucket(@NonNull KiiBucket bucket) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket must not be  null.");
        }
        Utils.checkInitialize(true);
        String bucketUrl = bucket.getBucketUrl();
        String postUrl = Utils.path(bucketUrl, "filters", "all", "push", "subscriptions", this.getTargetPath());
        HttpDelete request = new HttpDelete(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int unsubscribeBucket(@NonNull KiiBucket bucket, @NonNull KiiPushCallBack callback) {
        KiiPushSubscriptionTask task = new KiiPushSubscriptionTask(KiiPushSubscriptionTask.TaskType.UNSUBSCRIBE_BUCKET, this, bucket, null, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    @WorkerThread
    public void subscribe(@NonNull KiiSubscribable target) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (target == null) {
            throw new IllegalArgumentException("Target must not null");
        }
        Utils.checkInitialize(true);
        if (target instanceof KiiBucket) {
            this.subscribeBucket((KiiBucket)target);
        } else if (target instanceof KiiTopic) {
            this.subscribeTopic((KiiTopic)target);
        } else {
            throw new RuntimeException("Unexpected error.");
        }
    }

    public int subscribe(@NonNull KiiSubscribable target, @NonNull KiiPushCallBack callback) {
        KiiPushSubscriptionTask task = new KiiPushSubscriptionTask(KiiPushSubscriptionTask.TaskType.SUBSCRIBE, this, target, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    @WorkerThread
    public void unsubscribe(@NonNull KiiSubscribable target) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (target == null) {
            throw new IllegalArgumentException("Target must not null");
        }
        Utils.checkInitialize(true);
        if (target instanceof KiiBucket) {
            this.unsubscribeBucket((KiiBucket)target);
        } else if (target instanceof KiiTopic) {
            this.unsubscribeTopic((KiiTopic)target);
        } else {
            throw new RuntimeException("Unexpected error.");
        }
    }

    public int unsubscribe(@NonNull KiiSubscribable target, @NonNull KiiPushCallBack callback) {
        KiiPushSubscriptionTask task = new KiiPushSubscriptionTask(KiiPushSubscriptionTask.TaskType.UNSUBSCRIBE, this, target, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    private void subscribeTopic(KiiTopic topic) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String topicUri = topic.getUFEUri();
        String subscribeUri = Utils.path(topicUri, "push", "subscriptions", this.getTargetPath());
        HttpPut request = new HttpPut(subscribeUri);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    private void unsubscribeTopic(KiiTopic topic) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        String topicUri = topic.getUFEUri();
        String subscribeUri = Utils.path(topicUri, "push", "subscriptions", this.getTargetPath());
        HttpDelete request = new HttpDelete(subscribeUri);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    @WorkerThread
    public boolean isSubscribed(@NonNull KiiSubscribable target) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (target == null) {
            throw new IllegalArgumentException("Target must not null");
        }
        Utils.checkInitialize(true);
        String uri = null;
        if (target instanceof KiiBucket) {
            uri = Utils.path(((KiiBucket)target).getBucketUrl(), "filters", "all", "push", "subscriptions", this.getTargetPath());
        } else if (target instanceof KiiTopic) {
            uri = Utils.path(((KiiTopic)target).getUFEUri(), "push", "subscriptions", this.getTargetPath());
        } else {
            throw new RuntimeException("Unexpected error.");
        }
        return this.isSubscribed(uri);
    }

    public int isSubscribed(@NonNull KiiSubscribable target, @NonNull KiiPushCallBack callback) {
        KiiPushSubscriptionTask task = new KiiPushSubscriptionTask(KiiPushSubscriptionTask.TaskType.CHECK_SUBSCTIPTION, this, target, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    private boolean isSubscribed(String subscribeUri) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        HttpGet request = new HttpGet(subscribeUri);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        boolean isSubscribed = true;
        try {
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (NotFoundException nfe) {
            NotFoundException.Reason reason = nfe.getReason();
            if (reason.equals((Object)NotFoundException.Reason.PUSH_SUBSCRIPTION_NOT_FOUND)) {
                isSubscribed = false;
            }
            if (reason.equals((Object)NotFoundException.Reason.FILTER_NOT_FOUND)) {
                isSubscribed = false;
            }
            throw nfe;
        }
        return isSubscribed;
    }

    private String getTargetPath() {
        if (this.user != null) {
            return Utils.path("users", this.user.getID());
        }
        if (this.thing != null) {
            return Utils.path("things", this.thing.getID());
        }
        return "";
    }
}

