/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.APNSMessage;
import com.kii.cloud.storage.GCMMessage;
import com.kii.cloud.storage.JPushMessage;
import com.kii.cloud.storage.MqttMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiPushMessage {
    private Data messageData;
    private JSONObject parent;
    private JSONObject gcm;
    private JSONObject apns;
    private JSONObject jpush;
    private JSONObject mqtt;

    private KiiPushMessage(JSONObject parent, Data messageData, JSONObject gcm, JSONObject apns, JSONObject jpush, JSONObject mqtt) {
        this.parent = parent;
        this.messageData = messageData;
        this.gcm = gcm;
        this.apns = apns;
        this.jpush = jpush;
        this.mqtt = mqtt;
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject ret = null;
        try {
            ret = new JSONObject(this.parent.toString());
            ret.put("data", (Object)this.messageData.toJSONObject());
            ret.put("gcm", (Object)this.gcm);
            ret.put("apns", (Object)this.apns);
            ret.put("jpush", (Object)this.jpush);
            ret.put("mqtt", (Object)this.mqtt);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return ret;
    }

    @NonNull
    public static Builder buildWith(@NonNull Data messageData) {
        if (messageData == null) {
            throw new IllegalArgumentException("messageData can not be null");
        }
        return new Builder(messageData);
    }

    public static class Data {
        protected JSONObject data = new JSONObject();

        @NonNull
        public JSONObject toJSONObject() {
            try {
                JSONObject ret = new JSONObject(this.data.toString());
                return ret;
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
        }

        public void put(@NonNull String key, int value) {
            if (!this._isValidKey(key)) {
                throw new IllegalArgumentException("Key is invalid.");
            }
            try {
                this.data.put(key, value);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("can't accept " + key + " : " + value, e);
            }
        }

        public void put(@NonNull String key, long value) {
            if (!this._isValidKey(key)) {
                throw new IllegalArgumentException("Key is invalid.");
            }
            try {
                this.data.put(key, value);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("can't accept " + key + " : " + value, e);
            }
        }

        public void put(@NonNull String key, double value) {
            if (!this._isValidKey(key)) {
                throw new IllegalArgumentException("Key is invalid.");
            }
            try {
                this.data.put(key, value);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("can't accept " + key + " : " + value, e);
            }
        }

        public void put(@NonNull String key, boolean value) {
            if (!this._isValidKey(key)) {
                throw new IllegalArgumentException("Key is invalid.");
            }
            try {
                this.data.put(key, value);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("can't accept " + key + " : " + value, e);
            }
        }

        public void put(@NonNull String key, @Nullable String value) {
            if (!this._isValidKey(key)) {
                throw new IllegalArgumentException("Key is invalid.");
            }
            try {
                this.data.put(key, (Object)value);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("can't accept " + key + " : " + value, e);
            }
        }

        public static boolean isValidKey(@Nullable String key) {
            return !TextUtils.isEmpty((CharSequence)key);
        }

        protected boolean _isValidKey(String key) {
            return Data.isValidKey(key);
        }
    }

    public static class Builder {
        private Data messageData;
        private JSONObject parent = new JSONObject();
        private JSONObject gcm;
        private JSONObject apns;
        private JSONObject jpush;
        private JSONObject mqtt;

        Builder(Data messageData) {
            this.messageData = messageData;
            this.gcm = GCMMessage.builder().build().toJSON();
            this.apns = APNSMessage.builder().build().toJSON();
            this.jpush = JPushMessage.builder().build().toJSON();
            this.mqtt = MqttMessage.builder().build().toJSON();
        }

        @NonNull
        public Builder withGCMMessage(@NonNull GCMMessage message) {
            if (message == null) {
                throw new IllegalArgumentException("message can not be null");
            }
            this.gcm = message.toJSON();
            return this;
        }

        @NonNull
        public Builder withAPNSMessage(@NonNull APNSMessage message) {
            if (message == null) {
                throw new IllegalArgumentException("message can not be null");
            }
            this.apns = message.toJSON();
            return this;
        }

        @NonNull
        public Builder withJPushMessage(@NonNull JPushMessage message) {
            if (message == null) {
                throw new IllegalArgumentException("message can not be null");
            }
            this.jpush = message.toJSON();
            return this;
        }

        @NonNull
        public Builder withMqttMessage(@NonNull MqttMessage message) {
            if (message == null) {
                throw new IllegalArgumentException("message can not be null");
            }
            this.mqtt = message.toJSON();
            return this;
        }

        @NonNull
        public Builder enableGCM(boolean gcmEnabled) {
            try {
                this.gcm.put("enabled", gcmEnabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder enableAPNS(boolean apnsEnabled) {
            try {
                this.apns.put("enabled", apnsEnabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder enableJPush(boolean jpushEnabled) {
            try {
                this.jpush.put("enabled", jpushEnabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder enableMqtt(boolean mqttEnabled) {
            try {
                this.mqtt.put("enabled", mqttEnabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public KiiPushMessage build() {
            if (this.gcm.optBoolean("enabled") && this.messageData != null && !GCMMessage.GCMData.isValidGCMData(this.messageData)) {
                throw new IllegalStateException("Data contains key that is GCM reserve word");
            }
            KiiPushMessage msg = new KiiPushMessage(this.parent, this.messageData, this.gcm, this.apns, this.jpush, this.mqtt);
            return msg;
        }

        @NonNull
        public Builder withPushMessageType(@Nullable String pushMessageType) {
            try {
                this.parent.put("pushMessageType", (Object)pushMessageType);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendAppID(boolean isSendAppId) {
            try {
                this.parent.put("sendAppID", isSendAppId);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendSender(boolean sendSender) {
            try {
                this.parent.put("sendSender", sendSender);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendWhen(boolean sendWhen) {
            try {
                this.parent.put("sendWhen", sendWhen);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendOrigin(boolean sendOrigin) {
            try {
                this.parent.put("sendOrigin", sendOrigin);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendObjectScope(boolean sendObjectScope) {
            try {
                this.parent.put("sendObjectScope", sendObjectScope);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendTopicId(boolean sendTopicId) {
            try {
                this.parent.put("sendTopicID", sendTopicId);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendToProduction(boolean sendToProduction) {
            try {
                this.parent.put("sendToProduction", sendToProduction);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder sendToDevelopment(boolean sendToDevelopment) {
            try {
                this.parent.put("sendToDevelopment", sendToDevelopment);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }
    }
}

