/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.async.executor.CountTask;
import com.kii.cloud.async.executor.KiiBucketQueryTask;
import com.kii.cloud.async.executor.KiiBucketTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiACL;
import com.kii.cloud.storage.KiiBaseBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiSubscribable;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.CountCallBack;
import com.kii.cloud.storage.callback.KiiBucketCallBack;
import com.kii.cloud.storage.callback.KiiQueryCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.GroupOperationException;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.query.KiiClause;
import com.kii.cloud.storage.query.KiiQuery;
import com.kii.cloud.storage.query.KiiQueryResult;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferManager;
import com.kii.cloud.storage.resumabletransfer.impl.KiiRTransferManagerImpl;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiBucket
implements KiiBaseBucket,
KiiSubscribable {
    private KiiScope mParent;
    private String mBucketName;
    private static final String TAG = "KiiBucket";

    KiiBucket(KiiScope parent, String bucketName) {
        if (!KiiBucket.isValidBucketName(bucketName)) {
            throw new IllegalArgumentException("Invalid bucketName : " + bucketName);
        }
        this.mParent = parent;
        this.mBucketName = bucketName;
    }

    @NonNull
    public KiiObject object() {
        return new KiiObject(this.mParent, this.getQualifiedBucketName());
    }

    @NonNull
    public KiiObject object(@NonNull String objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Specified objectID is null");
        }
        if (!KiiObject.isValidObjectID(objectID)) {
            throw new IllegalArgumentException("Specified objectID is invalid");
        }
        return new KiiObject(this.mParent, this.getQualifiedBucketName(), objectID);
    }

    @WorkerThread
    @NonNull
    public KiiQueryResult<KiiObject> query(@Nullable KiiQuery query) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String bucketUrl = this.getBucketQueryUrl();
        HttpPost request = new HttpPost(bucketUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = null;
        try {
            if (query == null) {
                query = new KiiQuery((KiiClause)null);
            }
            Log.v(TAG, "query: " + query.toString());
            StringEntity entity = new StringEntity(query.toString(), "UTF-8");
            entity.setContentType("application/vnd.kii.QueryRequest+json");
            request.setEntity((HttpEntity)entity);
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject object = new JSONObject(res.body);
            JSONArray array = object.getJSONArray("results");
            String nextPaginationKey = object.optString("nextPaginationKey");
            Log.v(TAG, "nextPaginationKey: " + nextPaginationKey);
            Log.v(TAG, "count of result: " + array.length());
            ArrayList<KiiObject> results = new ArrayList<KiiObject>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject data = array.getJSONObject(i);
                KiiObject kiiObject = new KiiObject(this.mParent, this.getQualifiedBucketName(), data);
                results.add(kiiObject);
            }
            KiiQueryResult<KiiObject> queryResult = new KiiQueryResult<KiiObject>(query, results, nextPaginationKey, this);
            return queryResult;
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public int count() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        return this.count((KiiQuery)null);
    }

    @WorkerThread
    public int count(@Nullable KiiQuery query) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (query == null) {
            query = new KiiQuery();
        }
        String bucketUrl = this.getBucketQueryUrl();
        HttpPost request = new HttpPost(bucketUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = null;
        try {
            String queryString = this.countAggregationQuery(query);
            Log.v(TAG, "query: " + queryString);
            StringEntity entity = new StringEntity(queryString, "UTF-8");
            entity.setContentType("application/vnd.kii.QueryRequest+json");
            request.setEntity((HttpEntity)entity);
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject responseBody = new JSONObject(res.body);
            JSONObject aggregations = responseBody.getJSONObject("aggregations");
            int count = aggregations.getInt("count_field");
            return count;
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void count(@NonNull CountCallBack callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Specified callback is null");
        }
        this.count(null, callback);
    }

    public void count(@Nullable KiiQuery query, @NonNull CountCallBack callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Specified callback is null");
        }
        if (query == null) {
            query = new KiiQuery();
        }
        CountTask task = new CountTask(this, query, callback);
        KiiTaskExecutor.getInstance().execute(task);
    }

    private String getBucketQueryUrl() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        return Utils.path(this.getBucketUrl(), "query");
    }

    protected String getQualifiedBucketName() {
        return this.mBucketName;
    }

    String getBucketUrl() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        String qualifiedName = this.getQualifiedBucketName();
        if (this.mParent == null) {
            return Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "buckets", qualifiedName);
        }
        if (this.mParent instanceof KiiUser) {
            String parentId = this.getUserId((KiiUser)this.mParent);
            return Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", parentId, "buckets", qualifiedName);
        }
        if (this.mParent instanceof KiiGroup) {
            String parentId = this.getGroupId((KiiGroup)this.mParent);
            return Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", parentId, "buckets", qualifiedName);
        }
        if (this.mParent instanceof KiiThing) {
            String parentId = ((KiiThing)this.mParent).getID();
            return Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", parentId, "buckets", qualifiedName);
        }
        throw new IllegalStateException("Unknown scope");
    }

    @WorkerThread
    public void delete() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        Utils.checkInitialize(false);
        String deleteUrl = this.getBucketUrl();
        HttpDelete request = new HttpDelete(deleteUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public int delete(@NonNull KiiBucketCallBack<KiiBucket> callBack) {
        KiiBucketTask bucketTask = new KiiBucketTask(this, callBack);
        KiiTaskExecutor.getInstance().execute(bucketTask);
        return bucketTask.getTaskId();
    }

    private String getUserId(KiiUser parentUser) {
        String id = parentUser.getID();
        if (id == null) {
            throw new IllegalStateException("No login user");
        }
        return id;
    }

    private String getGroupId(KiiGroup parentGroup) throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        String id = parentGroup.getID();
        if (id != null) {
            return id;
        }
        try {
            parentGroup.save();
        }
        catch (GroupOperationException e) {
            Utils.throwException(e);
        }
        id = parentGroup.getID();
        return id;
    }

    public int query(@NonNull KiiQueryCallBack<KiiObject> callBack, @Nullable KiiQuery query) {
        KiiBucketQueryTask bucketTask = new KiiBucketQueryTask(this, callBack, query);
        KiiTaskExecutor.getInstance().execute(bucketTask);
        return bucketTask.getTaskId();
    }

    @NonNull
    public KiiACL acl() {
        return new KiiACL(this);
    }

    @NonNull
    public String getName() {
        return this.mBucketName;
    }

    public static boolean isValidBucketName(@Nullable String name) {
        return !TextUtils.isEmpty((CharSequence)name) && Utils.validateBucketName(name);
    }

    @NonNull
    public KiiRTransferManager getTransferManager() {
        return new KiiRTransferManagerImpl(this, this.toUri());
    }

    Uri toUri() {
        String prefix = "kiicloud://";
        String uriStr = null;
        String qualifiedName = this.getQualifiedBucketName();
        if (this.mParent == null) {
            uriStr = Utils.path(prefix, "buckets", qualifiedName);
        } else if (this.mParent instanceof KiiUser) {
            uriStr = Utils.path(prefix, "users", ((KiiUser)this.mParent).getID(), "buckets", qualifiedName);
        } else if (this.mParent instanceof KiiGroup) {
            uriStr = Utils.path(prefix, "groups", ((KiiGroup)this.mParent).getID(), "buckets", qualifiedName);
        } else if (this.mParent instanceof KiiThing) {
            uriStr = Utils.path(prefix, "things", ((KiiThing)this.mParent).getID(), "buckets", qualifiedName);
        } else {
            throw new RuntimeException("Unexpected error.");
        }
        return Uri.parse((String)uriStr);
    }

    String countAggregationQuery(KiiQuery query1) throws JSONException {
        JSONArray aggregations = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("type", (Object)"COUNT");
        json.put("putAggregationInto", (Object)"count_field");
        aggregations.put((Object)json);
        JSONObject queryJson = new JSONObject(query1.toString());
        JSONObject bucketQueryJson = queryJson.getJSONObject("bucketQuery");
        bucketQueryJson.put("aggregations", (Object)aggregations);
        queryJson.put("bucketQuery", (Object)bucketQueryJson);
        return queryJson.toString();
    }
}

