/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiPushMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class JPushMessage {
    private KiiPushMessage.Data data;
    private JSONObject parent;

    public JPushMessage(@NonNull JSONObject parent, @Nullable KiiPushMessage.Data data) {
        this.parent = parent;
        this.data = data;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject ret = null;
        try {
            ret = new JSONObject(this.parent.toString());
            if (this.data != null) {
                ret.put("data", (Object)this.data.toJSONObject());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return ret;
    }

    public static class Builder {
        private KiiPushMessage.Data data;
        private JSONObject parent = new JSONObject();

        @NonNull
        public JPushMessage build() {
            JPushMessage message = new JPushMessage(this.parent, this.data);
            return message;
        }

        Builder() {
            try {
                this.parent.put("enabled", true);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
        }

        @NonNull
        public Builder enable(boolean enabled) {
            try {
                this.parent.put("enabled", enabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withJPushData(@Nullable JPushData data) {
            this.data = data;
            return this;
        }
    }

    public static class JPushData
    extends KiiPushMessage.Data {
        public static boolean isValidKey(@Nullable String key) {
            return KiiPushMessage.Data.isValidKey(key);
        }
    }
}

