/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.callback.KiiUserCallBack;
import java.util.List;

public class KiiUserTask
implements KiiTask,
Runnable {
    TaskType type;
    KiiUserCallBack callback;
    KiiUser target;
    KiiUser foundUser;
    List<KiiGroup> memberOfGroups;
    List<KiiGroup> ownerOfGroups;
    Exception e;
    Object[] arguments;
    int taskId;

    public KiiUserTask(@NonNull TaskType type, @Nullable KiiUser target, @NonNull KiiUserCallBack callback, Object ... arguments) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public void run() {
        switch (this.type) {
            case LOGIN: {
                this.doLogin();
                break;
            }
            case LOGIN_WITH_LOCALPHONE: {
                this.doLoginWithLocalPhone();
                break;
            }
            case LOGIN_WITH_TOKEN: {
                this.doLoginWithToken();
                break;
            }
            case REGISTER: {
                this.doRegister();
                break;
            }
            case CHANGE_PASSWORD: {
                this.doChangePassword();
                break;
            }
            case UPDATE: {
                this.doUpdate();
                break;
            }
            case DELETE: {
                this.doDelete();
                break;
            }
            case REFRESH: {
                this.doRefresh();
                break;
            }
            case RESET_PASSWORD: {
                this.doResetPassword();
                break;
            }
            case VERIFY_PHONE: {
                this.doVerifyPhone();
                break;
            }
            case CHANGE_PHONE: {
                this.doChangePhone();
                break;
            }
            case CHANGE_EMAIL: {
                this.doChangeEmail();
                break;
            }
            case REQUEST_RESEND_PHONE_VERIFICATION_CODE: {
                this.doRequestResendPhoneVerificationCode();
                break;
            }
            case REQUEST_RESEND_EMAIL_VERIFICATION: {
                this.doRequestResendEmailVerification();
                break;
            }
            case MEMBER_OF_GROUPS: {
                this.doMemberOfGroups();
                break;
            }
            case OWNER_OF_GROUPS: {
                this.doOwnerOfGroups();
                break;
            }
            case FIND_BY_EMAIL: {
                this.doFindByEmail();
                break;
            }
            case FIND_BY_PHONE: {
                this.doFindByPhone();
                break;
            }
            case FIND_BY_NAME: {
                this.doFindByName();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    private void doLogin() {
        try {
            KiiUser user;
            this.assertLoginArguments(this.arguments);
            this.target = user = KiiUser.logIn((String)this.arguments[0], (String)this.arguments[1]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doLoginWithLocalPhone() {
        try {
            KiiUser user;
            this.assertLoginWithLocalPhoneArguments(this.arguments);
            this.target = user = KiiUser.logInWithLocalPhone((String)this.arguments[0], (String)this.arguments[1], (String)this.arguments[2]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertOneStringArguments(Object ... arguments) {
        if (this.arguments == null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (this.arguments.length != 1) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[0] instanceof String) && this.arguments[0] != null) {
            throw new RuntimeException("Unexpected error.");
        }
    }

    private void assertTwoStringArguments(Object ... arguments) {
        if (this.arguments == null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (this.arguments.length != 2) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[0] instanceof String) && this.arguments[0] != null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[1] instanceof String) && this.arguments[1] != null) {
            throw new RuntimeException("Unexpected error.");
        }
    }

    private void assertThreeStringArguments(Object ... arguments) {
        if (this.arguments == null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (this.arguments.length != 3) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[0] instanceof String) && this.arguments[0] != null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[1] instanceof String) && this.arguments[1] != null) {
            throw new RuntimeException("Unexpected error.");
        }
        if (!(this.arguments[2] instanceof String) && this.arguments[2] != null) {
            throw new RuntimeException("Unexpected error.");
        }
    }

    private void assertLoginWithLocalPhoneArguments(Object ... arguments) {
        this.assertThreeStringArguments(arguments);
    }

    private void assertLoginArguments(Object ... arguments) {
        this.assertTwoStringArguments(arguments);
    }

    private void doLoginWithToken() {
        try {
            KiiUser user;
            this.assertLoginWithTokenArguments(this.arguments);
            this.target = user = KiiUser.loginWithToken((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertLoginWithTokenArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doRegister() {
        try {
            this.assertRegisterArguments(this.arguments);
            this.target.register((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertRegisterArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doChangePassword() {
        try {
            this.assertChangePasswordArguments(this.arguments);
            this.target.changePassword((String)this.arguments[0], (String)this.arguments[1]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertChangePasswordArguments(Object ... arguments) {
        this.assertTwoStringArguments(arguments);
    }

    private void doUpdate() {
        try {
            this.target.update();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doDelete() {
        try {
            this.target.delete();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doRefresh() {
        try {
            this.target.refresh();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doResetPassword() {
        try {
            this.assertResetPasswordArguments(this.arguments);
            KiiUser.resetPassword((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertResetPasswordArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doVerifyPhone() {
        try {
            this.assertVerifyPhoneArguments(this.arguments);
            this.target.verifyPhone((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertVerifyPhoneArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doChangePhone() {
        try {
            this.assertChangePhoneArguments(this.arguments);
            KiiUser.changePhone((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertChangePhoneArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doChangeEmail() {
        try {
            this.assertChangeEmailArguments(this.arguments);
            KiiUser.changeEmail((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void assertChangeEmailArguments(Object ... arguments) {
        this.assertOneStringArguments(arguments);
    }

    private void doRequestResendPhoneVerificationCode() {
        try {
            KiiUser.requestResendPhoneVerificationCode();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doRequestResendEmailVerification() {
        try {
            KiiUser.requestResendEmailVerification();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doMemberOfGroups() {
        try {
            this.memberOfGroups = this.target.memberOfGroups();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doOwnerOfGroups() {
        try {
            this.ownerOfGroups = this.target.ownerOfGroups();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doFindByName() {
        try {
            this.assertOneStringArguments(this.arguments);
            this.foundUser = KiiUser.findUserByUserName((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doFindByPhone() {
        try {
            this.assertOneStringArguments(this.arguments);
            this.foundUser = KiiUser.findUserByPhone((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doFindByEmail() {
        try {
            this.assertOneStringArguments(this.arguments);
            this.foundUser = KiiUser.findUserByEmail((String)this.arguments[0]);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case LOGIN: 
            case LOGIN_WITH_LOCALPHONE: 
            case LOGIN_WITH_TOKEN: {
                this.callback.onLoginCompleted(this.taskId, this.target, this.e);
                break;
            }
            case REGISTER: {
                this.callback.onRegisterCompleted(this.taskId, this.target, this.e);
                break;
            }
            case CHANGE_PASSWORD: {
                this.callback.onChangePasswordCompleted(this.taskId, this.e);
                break;
            }
            case UPDATE: {
                this.callback.onUpdateCompleted(this.taskId, this.target, this.e);
                break;
            }
            case DELETE: {
                this.callback.onDeleteCompleted(this.taskId, this.e);
                break;
            }
            case REFRESH: {
                this.callback.onRefreshCompleted(this.taskId, this.e);
                break;
            }
            case RESET_PASSWORD: {
                this.callback.onResetPasswordCompleted(this.taskId, this.e);
                break;
            }
            case VERIFY_PHONE: {
                this.callback.onVerifyPhoneCompleted(this.taskId, this.e);
                break;
            }
            case CHANGE_PHONE: {
                this.callback.onChangePhoneCompleted(this.taskId, this.e);
                break;
            }
            case CHANGE_EMAIL: {
                this.callback.onChangeEmailCompleted(this.taskId, this.e);
                break;
            }
            case REQUEST_RESEND_PHONE_VERIFICATION_CODE: {
                this.callback.onRequestResendPhoneVerificationCodeCompleted(this.taskId, this.e);
                break;
            }
            case REQUEST_RESEND_EMAIL_VERIFICATION: {
                this.callback.onRequestResendEmailVerificationCodeCompleted(this.taskId, this.e);
                break;
            }
            case MEMBER_OF_GROUPS: {
                this.callback.onMemberOfGroupsCompleted(this.taskId, this.target, this.memberOfGroups, this.e);
                break;
            }
            case OWNER_OF_GROUPS: {
                this.callback.onOwnerOfGroupsCompleted(this.taskId, this.target, this.ownerOfGroups, this.e);
                break;
            }
            case FIND_BY_EMAIL: 
            case FIND_BY_PHONE: 
            case FIND_BY_NAME: {
                this.callback.onFindCompleted(this.taskId, this.target, this.foundUser, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        LOGIN,
        LOGIN_WITH_LOCALPHONE,
        LOGIN_WITH_TOKEN,
        REGISTER,
        CHANGE_PASSWORD,
        UPDATE,
        DELETE,
        REFRESH,
        RESET_PASSWORD,
        VERIFY_PHONE,
        CHANGE_PHONE,
        CHANGE_EMAIL,
        REQUEST_RESEND_PHONE_VERIFICATION_CODE,
        REQUEST_RESEND_EMAIL_VERIFICATION,
        MEMBER_OF_GROUPS,
        OWNER_OF_GROUPS,
        FIND_BY_EMAIL,
        FIND_BY_PHONE,
        FIND_BY_NAME;

    }
}

