/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiPushSubscription;
import com.kii.cloud.storage.KiiSubscribable;
import com.kii.cloud.storage.callback.KiiPushCallBack;

public class KiiPushSubscriptionTask
implements KiiTask,
Runnable {
    TaskType type;
    KiiPushCallBack callback;
    KiiPushSubscription target;
    KiiBucket bucket;
    KiiSubscribable subscribable;
    String regId;
    boolean isSubscribed;
    Exception e;
    int taskId;

    public KiiPushSubscriptionTask(@NonNull TaskType type, @NonNull KiiPushSubscription target, @NonNull KiiBucket bucket, @Nullable String regId, @NonNull KiiPushCallBack callback) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.bucket = bucket;
        this.regId = regId;
    }

    public KiiPushSubscriptionTask(@NonNull TaskType type, @NonNull KiiPushSubscription target, @NonNull KiiSubscribable subscribable, @NonNull KiiPushCallBack callback) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.subscribable = subscribable;
    }

    @Override
    public void run() {
        switch (this.type) {
            case SUBSCRIBE_BUCKET: {
                this.doSubscribeBucket();
                break;
            }
            case UNSUBSCRIBE_BUCKET: {
                this.doUnsubscribeBucket();
                break;
            }
            case SUBSCRIBE: {
                this.doSubscribe();
                break;
            }
            case UNSUBSCRIBE: {
                this.doUnSubscribe();
                break;
            }
            case CHECK_SUBSCTIPTION: {
                this.doCheckSubscription();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    private void doCheckSubscription() {
        try {
            this.isSubscribed = this.target.isSubscribed(this.subscribable);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doSubscribeBucket() {
        try {
            this.target.subscribeBucket(this.bucket);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doUnsubscribeBucket() {
        try {
            this.target.unsubscribeBucket(this.bucket);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doSubscribe() {
        try {
            this.target.subscribe(this.subscribable);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doUnSubscribe() {
        try {
            this.target.unsubscribe(this.subscribable);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case SUBSCRIBE_BUCKET: {
                this.callback.onSubscribeBucketCompleted(this.taskId, this.bucket, this.e);
                break;
            }
            case UNSUBSCRIBE_BUCKET: {
                this.callback.onUnSubscribeBucketCompleted(this.taskId, this.bucket, this.e);
                break;
            }
            case SUBSCRIBE: {
                this.callback.onSubscribeCompleted(this.taskId, this.subscribable, this.e);
                break;
            }
            case UNSUBSCRIBE: {
                this.callback.onUnSubscribeCompleted(this.taskId, this.subscribable, this.e);
                break;
            }
            case CHECK_SUBSCTIPTION: {
                this.callback.onCheckSubscriptionCompleted(this.taskId, this.subscribable, this.isSubscribed, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        SUBSCRIBE_BUCKET,
        UNSUBSCRIBE_BUCKET,
        SUBSCRIBE,
        UNSUBSCRIBE,
        CHECK_SUBSCTIPTION;

    }
}

