/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.callback.KiiObjectCallBack;

public class KiiObjectTask
implements KiiTask,
Runnable {
    TaskType type;
    KiiObjectCallBack callback;
    KiiObject target;
    Exception e;
    Object[] arguments;
    int taskId;

    public KiiObjectTask(@NonNull TaskType type, @NonNull KiiObject target, @Nullable KiiObjectCallBack callback, Object ... arguments) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public void run() {
        switch (this.type) {
            case SAVE: {
                this.doSave();
                break;
            }
            case SAVE_ALLFIELDS: {
                this.doSaveAll();
                break;
            }
            case DELETE: {
                this.doDelete();
                break;
            }
            case REFRESH: {
                this.doRefresh();
                break;
            }
            case DELETE_BODY: {
                this.doDeleteBody();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    private void doSave() {
        try {
            boolean overWrite = false;
            if (this.arguments != null && this.arguments.length > 0) {
                if (this.arguments[0] instanceof Boolean) {
                    overWrite = (Boolean)this.arguments[0];
                    this.target.save(overWrite);
                }
            } else {
                this.target.save();
            }
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doSaveAll() {
        try {
            boolean overWrite = false;
            if (this.arguments != null && this.arguments.length > 0) {
                if (!(this.arguments[0] instanceof Boolean)) {
                    throw new RuntimeException("Unexpected error");
                }
            } else {
                throw new RuntimeException("Unexpected error");
            }
            overWrite = (Boolean)this.arguments[0];
            this.target.saveAllFields(overWrite);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doDelete() {
        try {
            this.target.delete();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doDeleteBody() {
        try {
            this.target.deleteBody();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doRefresh() {
        try {
            this.target.refresh();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        if (this.callback == null) {
            return;
        }
        switch (this.type) {
            case SAVE: 
            case SAVE_ALLFIELDS: {
                this.callback.onSaveCompleted(this.taskId, this.target, this.e);
                break;
            }
            case DELETE: {
                this.callback.onDeleteCompleted(this.taskId, this.e);
                break;
            }
            case REFRESH: {
                this.callback.onRefreshCompleted(this.taskId, this.target, this.e);
                break;
            }
            case DELETE_BODY: {
                this.callback.onDeleteBodyCompleted(this.taskId, this.target, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        if (this.callback != null) {
            this.callback.onTaskStart(this.taskId);
        }
    }

    @Override
    public void executeCancelCallback() {
        if (this.callback != null) {
            this.callback.onTaskCancel(this.taskId);
        }
    }

    public static enum TaskType {
        SAVE,
        SAVE_ALLFIELDS,
        DELETE,
        REFRESH,
        DELETE_BODY;

    }
}

