/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl;

import android.support.annotation.NonNull;
import com.kii.cloud.analytics.KiiAnalyticsException;
import com.kii.cloud.analytics.impl.ApiResponse;
import com.kii.cloud.analytics.impl.Log;
import com.kii.cloud.storage.engine._HttpClientFactory;
import com.kii.cloud.storage.engine._HttpClientFactoryOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public class KiiAnalyticsEngine {
    private static final String TAG = "KiiAnalyticsEngine";
    private static _HttpClientFactory clientFactory = new _HttpClientFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ApiResponse httpRequest2(@NonNull HttpUriRequest request) throws KiiAnalyticsException {
        BufferedReader reader = null;
        ApiResponse res = new ApiResponse();
        try {
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(true);
            HttpClient client = clientFactory.createClient(options);
            Log.v(TAG, request.getMethod() + " " + request.getURI());
            for (int i = 0; i < request.getAllHeaders().length; ++i) {
                Log.v(TAG, "request:" + request.getAllHeaders()[i]);
            }
            HttpResponse response = null;
            try {
                response = client.execute(request);
            }
            catch (IOException e) {
                throw new KiiAnalyticsException(e.getMessage(), e);
            }
            int status = response.getStatusLine().getStatusCode();
            Log.i(TAG, "Http status code:" + status);
            StringBuilder sb = new StringBuilder();
            try {
                if (status != 204) {
                    reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                    String s = reader.readLine();
                    while (s != null) {
                        sb.append(s);
                        s = reader.readLine();
                    }
                    Log.v(TAG, "Client.apiRequest(): Response: " + sb.toString());
                }
            }
            catch (IOException e) {
                throw new KiiAnalyticsException(e.getMessage(), e);
            }
            if (status >= 300) {
                throw new KiiAnalyticsException("Bad response from server", null, status, sb.toString());
            }
            res.status = response.getStatusLine().getStatusCode();
            Header[] headers = response.getHeaders("ETag");
            if (headers != null && headers.length > 0) {
                res.eTag = headers[0].getValue();
            }
            res.body = sb.toString();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ApiResponse httpRequest3(@NonNull HttpUriRequest request) throws IOException {
        ApiResponse res = new ApiResponse();
        try (BufferedReader reader = null;){
            Header contentType;
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(true);
            HttpClient client = clientFactory.createClient(options);
            Log.v(TAG, request.getMethod() + " " + request.getURI());
            for (int i = 0; i < request.getAllHeaders().length; ++i) {
                Log.v(TAG, "request:" + request.getAllHeaders()[i]);
            }
            HttpResponse response = client.execute(request);
            int status = response.getStatusLine().getStatusCode();
            Log.i(TAG, "Http status code:" + status);
            StringBuilder sb = new StringBuilder();
            if (status != 204) {
                reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String s = reader.readLine();
                while (s != null) {
                    sb.append(s);
                    s = reader.readLine();
                }
                Log.v(TAG, "Client.apiRequest(): Response: " + sb.toString());
            }
            res.status = response.getStatusLine().getStatusCode();
            res.body = sb.toString();
            Header[] headers = response.getHeaders("ETag");
            if (headers != null && headers.length > 0) {
                res.eTag = headers[0].getValue();
            }
            if ((contentType = response.getFirstHeader("Content-Type")) != null) {
                res.contentType = contentType.getValue();
            }
        }
        return res;
    }
}

