/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.kii.cloud.analytics.KiiAnalytics;
import com.kii.cloud.analytics.impl.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.UUID;

class UUIDManager {
    private static final String FILENAME = "genuuid";
    private static final String TAG = "UUIDManager";
    private static String uuidCache = null;

    UUIDManager() {
    }

    @NonNull
    public static synchronized String getUUID() {
        if (TextUtils.isEmpty((CharSequence)uuidCache) && TextUtils.isEmpty((CharSequence)(uuidCache = UUIDManager.getStoredUUID()))) {
            uuidCache = UUID.randomUUID().toString();
            UUIDManager.storeUUID(uuidCache);
        }
        Log.v(TAG, "return UUID:" + uuidCache);
        return uuidCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStoredUUID() {
        BufferedReader br = null;
        FileInputStream fis = null;
        String ret = null;
        try {
            fis = KiiAnalytics.getContext().openFileInput(FILENAME);
            br = new BufferedReader(new InputStreamReader(fis));
            ret = br.readLine();
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.v(TAG, "read UUID:" + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeUUID(String uuid) {
        BufferedWriter br = null;
        FileOutputStream fos = null;
        try {
            fos = KiiAnalytics.getContext().openFileOutput(FILENAME, 0);
            br = new BufferedWriter(new OutputStreamWriter(fos));
            br.write(uuid);
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

