/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.analytics.KiiAnalyticsFormatException;
import com.kii.cloud.analytics.KiiEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class KeyValueObject {
    protected JSONObject mJSON;

    KeyValueObject() {
    }

    public boolean has(@NonNull String key) {
        return this.mJSON.has(key);
    }

    public void remove(@NonNull String key) {
        this.mJSON.remove(key);
    }

    @Nullable
    public String getString(@NonNull String key) {
        try {
            return this.mJSON.getString(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    @Nullable
    public String optString(@NonNull String key, @Nullable String defaultValue) {
        return this.mJSON.optString(key, defaultValue);
    }

    public void set(@NonNull String key, @NonNull String value) {
        KiiEvent.validateKey(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            throw new KiiAnalyticsFormatException("Value can not be null or empty");
        }
        try {
            this.mJSON.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    public boolean getBoolean(@NonNull String key) {
        try {
            return this.mJSON.getBoolean(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    public boolean optBoolean(@NonNull String key, boolean defaultValue) {
        return this.mJSON.optBoolean(key, defaultValue);
    }

    public void set(@NonNull String key, boolean value) {
        KiiEvent.validateKey(key);
        try {
            this.mJSON.put(key, value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    public int getInt(@NonNull String key) {
        try {
            return this.mJSON.getInt(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    public int optInt(@NonNull String key, int defaultValue) {
        return this.mJSON.optInt(key, defaultValue);
    }

    public void set(@NonNull String key, int value) {
        KiiEvent.validateKey(key);
        try {
            this.mJSON.put(key, value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    public long getLong(@NonNull String key) {
        try {
            return this.mJSON.getLong(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    public long optLong(@NonNull String key, long defaultValue) {
        return this.mJSON.optLong(key, defaultValue);
    }

    public void set(@NonNull String key, long value) {
        KiiEvent.validateKey(key);
        try {
            this.mJSON.put(key, value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    public void setIntArray(@NonNull String key, int ... values) {
        KiiEvent.validateKey(key);
        if (values == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Expects an array which size is greater than zero");
        }
        JSONArray jarr = new JSONArray();
        for (int v : values) {
            jarr.put(v);
        }
        try {
            this.mJSON.put(key, (Object)jarr);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + values, e);
        }
    }

    @NonNull
    public int[] getIntArray(@NonNull String key) {
        try {
            JSONArray jarr = this.mJSON.getJSONArray(key);
            int[] ret = new int[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getInt(i);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("No int array assosiated with the specified key:" + key, e);
        }
    }

    @Nullable
    public int[] optIntArray(@NonNull String key) {
        if (!this.mJSON.has(key)) {
            return null;
        }
        JSONArray jarr = this.mJSON.optJSONArray(key);
        if (jarr == null) {
            return null;
        }
        try {
            int[] ret = new int[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getInt(i);
            }
            return ret;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void setStringArray(@NonNull String key, String ... values) {
        KiiEvent.validateKey(key);
        if (values == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Expects an array which size is greater than zero");
        }
        JSONArray jarr = new JSONArray();
        for (String v : values) {
            jarr.put((Object)v);
        }
        try {
            this.mJSON.put(key, (Object)jarr);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + values, e);
        }
    }

    @NonNull
    public String[] getStringArray(@NonNull String key) {
        try {
            JSONArray jarr = this.mJSON.getJSONArray(key);
            String[] ret = new String[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getString(i);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("No int array assosiated with the specified key:" + key, e);
        }
    }

    @Nullable
    public String[] optStringArray(@NonNull String key) {
        if (!this.mJSON.has(key)) {
            return null;
        }
        JSONArray jarr = this.mJSON.optJSONArray(key);
        if (jarr == null) {
            return null;
        }
        try {
            String[] ret = new String[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getString(i);
            }
            return ret;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void setLongArray(@NonNull String key, long ... values) {
        KiiEvent.validateKey(key);
        if (values == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Expects an array which size is greater than zero");
        }
        JSONArray jarr = new JSONArray();
        for (long v : values) {
            jarr.put(v);
        }
        try {
            this.mJSON.put(key, (Object)jarr);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + values, e);
        }
    }

    @NonNull
    public long[] getLongArray(@NonNull String key) {
        try {
            JSONArray jarr = this.mJSON.getJSONArray(key);
            long[] ret = new long[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getLong(i);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("No int array assosiated with the specified key:" + key, e);
        }
    }

    @Nullable
    public long[] optLongArray(@NonNull String key) {
        if (!this.mJSON.has(key)) {
            return null;
        }
        JSONArray jarr = this.mJSON.optJSONArray(key);
        if (jarr == null) {
            return null;
        }
        try {
            long[] ret = new long[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = jarr.getLong(i);
            }
            return ret;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void setFloatArray(@NonNull String key, float ... values) {
        KiiEvent.validateKey(key);
        if (values == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("Expects an array which size is greater than zero");
        }
        JSONArray jarr = new JSONArray();
        for (float v : values) {
            jarr.put((Object)v);
        }
        try {
            this.mJSON.put(key, (Object)jarr);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + values, e);
        }
    }

    @NonNull
    public float[] getFloatArray(@NonNull String key) {
        try {
            JSONArray jarr = this.mJSON.getJSONArray(key);
            float[] ret = new float[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = (float)jarr.getDouble(i);
            }
            return ret;
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("No int array assosiated with the specified key:" + key, e);
        }
    }

    @Nullable
    public float[] optFloatArray(@NonNull String key) {
        if (!this.mJSON.has(key)) {
            return null;
        }
        JSONArray jarr = this.mJSON.optJSONArray(key);
        if (jarr == null) {
            return null;
        }
        try {
            float[] ret = new float[jarr.length()];
            for (int i = 0; i < jarr.length(); ++i) {
                ret[i] = (float)jarr.getDouble(i);
            }
            return ret;
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected JSONObject getJSONObject(String key) {
        try {
            return this.mJSON.getJSONObject(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    protected JSONObject optJSONObject(String key) {
        return this.mJSON.optJSONObject(key);
    }

    protected void set(String key, JSONObject value) {
        try {
            this.mJSON.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    protected JSONArray getJSONArray(String key) {
        try {
            return this.mJSON.getJSONArray(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    protected JSONArray optJSONArray(String key) {
        return this.mJSON.optJSONArray(key);
    }

    protected void set(String key, JSONArray value) {
        try {
            this.mJSON.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }

    public float getFloat(@NonNull String key) {
        try {
            return (float)this.mJSON.getDouble(key);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Key has not exist" + key, e);
        }
    }

    public float optFloat(@NonNull String key, float defaultValue) {
        return (float)this.mJSON.optDouble(key, (double)defaultValue);
    }

    public void set(@NonNull String key, float value) {
        KiiEvent.validateKey(key);
        try {
            this.mJSON.put(key, (double)value);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsFormatException("Invalid key value pair key:" + key + " value: " + value, e);
        }
    }
}

