/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.abtesting;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.abtesting.ExperimentNotAppliedException;
import com.kii.cloud.abtesting.KiiExperiment;
import com.kii.cloud.abtesting.Variation;
import com.kii.cloud.abtesting.VariationSampler;
import com.kii.cloud.storage.KiiUser;
import java.util.ArrayList;
import java.util.Random;

public class VariationSamplerByKiiUser
implements VariationSampler {
    @Override
    @Nullable
    public Variation chooseVariation(@NonNull KiiExperiment experiment) throws ExperimentNotAppliedException {
        KiiUser user = KiiUser.getCurrentUser();
        if (user == null) {
            throw new IllegalStateException("KiiUser is not logged-in");
        }
        switch (experiment.getStatus()) {
            case RUNNING: {
                Uri uri = user.toUri();
                String id = uri.getLastPathSegment();
                int hashCode = id.hashCode();
                int random = new Random(hashCode).nextInt(100);
                Variation[] vs = experiment.getVariations();
                ArrayList<Integer> percentages = new ArrayList<Integer>();
                for (Variation v : vs) {
                    int percentage = v.getPercentage();
                    if (percentage > 100) {
                        percentage = 100;
                    }
                    percentages.add(percentage);
                }
                int randomSum = 0;
                int i = 0;
                for (Integer p : percentages) {
                    if (random < (randomSum += p.intValue())) {
                        return vs[i];
                    }
                    ++i;
                }
                throw new RuntimeException("Unexpected error.");
            }
            case PAUSED: {
                throw new ExperimentNotAppliedException("Experiment has paused.", ExperimentNotAppliedException.Reason.EXPERIMENT_PAUSED);
            }
            case DRAFT: {
                throw new ExperimentNotAppliedException("Experiment is draft.", ExperimentNotAppliedException.Reason.EXPERIMENT_DRAFT);
            }
            case TERMINATED: {
                Variation chosenVariation = experiment.getChosenVariation();
                if (chosenVariation != null) {
                    return chosenVariation;
                }
                throw new ExperimentNotAppliedException("Experiment has terminated with no specified variation.", ExperimentNotAppliedException.Reason.EXPERIMENT_TERMINATED_WITH_NO_VARIATION);
            }
        }
        throw new RuntimeException("Unknown status!");
    }
}

