/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.ParameterException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MimeType {
    JPEG("image/jpeg", null),
    PJPEG("image/pjpeg", null),
    THREE_GP("video/3gpp", ".3gp"),
    AVI("video/avi", ".avi"),
    QUICKTIME("video/quicktime", ".mov"),
    MP4("video/mp4", ".mp4"),
    VND_MTS("video/vnd.mts", ".mts"),
    MPEG("video/mpeg", ".m2ts");

    private static final Map<String, MimeType> MAP;
    private final String label;
    private final String ext;

    private MimeType(String label, String ext) {
        this.label = label;
        this.ext = ext;
    }

    public String getLabel() {
        return this.label;
    }

    public String getExt() {
        return this.ext;
    }

    public static MimeType fromString(String label) throws ParameterException {
        MimeType retval = MAP.get(label);
        if (retval == null) {
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("unexptected label %s", label));
        }
        return retval;
    }

    static {
        MAP = new HashMap<String, MimeType>();
        for (MimeType mimeType : MimeType.values()) {
            MAP.put(mimeType.getLabel(), mimeType);
        }
    }
}

