/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.util.Log;
import com.kii.sdk.photocolle.ApplicationLayerException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Command;
import com.kii.sdk.photocolle.ContentGUID;
import com.kii.sdk.photocolle.ContentThumbnailInfo;
import com.kii.sdk.photocolle.ContentThumbnailInfoList;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.Logic;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.ResponseUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetContentThumbnailInfoLogic
implements Logic<Args, ContentThumbnailInfoList> {
    private static final URL DEFAULT_URL = Command.toUrl("https://xlb.photocolle-docomo.com/file_a2/4.0/ext/thumbnail_list/get");

    GetContentThumbnailInfoLogic() {
    }

    @Override
    public HttpUriRequest createRequest(URL url, Args arg) {
        try {
            HttpPost retval = new HttpPost(url.toURI());
            Command.signRequest((HttpRequestBase)retval, arg.context);
            JSONArray array = new JSONArray();
            for (ContentGUID guid : arg.contentGUIDs) {
                array.put((Object)guid.getString());
            }
            JSONObject json = new JSONObject();
            json.put("content_info_list", (Object)array);
            retval.setEntity(Command.generateJSONEntity(json));
            return retval;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ContentThumbnailInfoList parseResponse(HttpResponse response) throws HttpException, ApplicationLayerException, ResponseBodyParseException, InvalidTokenException {
        try {
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                ResponseUtil.throwHttpStatusRelatedException(response);
            }
            JSONObject json = ResponseUtil.newJSONObject(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            int result = ResponseUtil.getInt(json, "result");
            switch (result) {
                case 0: {
                    return this.toContentThumbnailInfoList(json);
                }
                case 1: {
                    Log.e((String)"GetContentThumbnailInfoLogic", (String)String.format("Error: %s", json.toString()));
                    throw ResponseUtil.newApplicationLayerException(json);
                }
            }
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "result is out of range: " + result);
        }
        catch (IOException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParseException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    private ContentThumbnailInfoList toContentThumbnailInfoList(JSONObject json) throws ResponseBodyParseException {
        ContentThumbnailInfoList retval = new ContentThumbnailInfoList();
        JSONArray array = ResponseUtil.getArrayInRangeMinMax(json, "content_info_list", 1, 100);
        List<ContentThumbnailInfo> list = retval.getList();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            list.add(this.toContentThumbnailInfo(ResponseUtil.getJSONObjectFromArray(array, i)));
        }
        JSONArray ngArray = ResponseUtil.optArrayInRangeMinMax(json, "ng_list", 0, 99);
        if (ngArray != null) {
            List<ContentGUID> ngList = retval.getNGList();
            int len2 = ngArray.length();
            for (int i = 0; i < len2; ++i) {
                ngList.add(ResponseUtil.newContentGUIDWithLengthRange(ResponseUtil.getStringFromArray(ngArray, i), 1, 50));
            }
        }
        return retval;
    }

    private ContentThumbnailInfo toContentThumbnailInfo(JSONObject json) throws ResponseBodyParseException {
        return new ContentThumbnailInfo(ResponseUtil.getContentGUIDWithLengthRange(json, "content_guid", 1, 50), ResponseUtil.getMimeType(json, "mime_type"), ResponseUtil.getThumbnail(json, "thumbnail"));
    }

    @Override
    public URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    public static class Args {
        public final AuthenticationContext context;
        public final List<ContentGUID> contentGUIDs;

        public Args(AuthenticationContext context, ContentGUID ... contentGUIDs) {
            if (context == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "context must not be null.");
            }
            if (contentGUIDs == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "contextGUIDs must not be null.");
            }
            if (contentGUIDs.length < 1 || contentGUIDs.length > 100) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("length of contentGUIDs is out of range: %d", contentGUIDs.length));
            }
            for (ContentGUID guid : contentGUIDs) {
                if (guid == null) {
                    throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "contextGUID must not be null.");
                }
                if (guid.getString() == null) {
                    throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "value of contentGUID must not be null.");
                }
                if (guid.getString().length() >= 1 && guid.getString().length() <= 50) continue;
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("length of contentGUID is out of range: %d", guid.getString().length()));
            }
            this.context = context;
            this.contentGUIDs = Arrays.asList(contentGUIDs);
        }
    }
}

