/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.ParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileType {
    ALL(0, "All"),
    IMAGE(1, "Image"),
    VIDEO(2, "Video"),
    SLIDE_MOVIE(3, "SlideMovie");

    private final int number;
    private final String label;

    private FileType(int number, String label) {
        this.number = number;
        this.label = label;
    }

    public int getNumber() {
        return this.number;
    }

    public String getLabel() {
        return this.label;
    }

    public static FileType fromInt(int number) {
        switch (number) {
            case 0: {
                return ALL;
            }
            case 1: {
                return IMAGE;
            }
            case 2: {
                return VIDEO;
            }
            case 3: {
                return SLIDE_MOVIE;
            }
        }
        throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("unexptected number %d", number));
    }
}

