/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.kii.sdk.photocolle.AuthorizationData;
import com.kii.sdk.photocolle.ConnectionException;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthHiddenActivity
extends Activity {
    static final String KEY_AUTH_URL = "authUrl";
    static final String KEY_TOKEN_URL = "tokenUrl";
    static final String KEY_CLIENT_ID = "clientId";
    static final String KEY_CLIENT_SECRET = "clientSecret";
    static final String KEY_SCOPES = "scopes";
    static final String KEY_REDIRECT_URI = "redirectUri";
    static final String KEY_EXCEPTION = "exception";
    static final String KEY_AUTHORIZATION_DATA = "authorizationData";
    static final String KEY_ERROR_CODE = "errorCode";
    static final String KEY_NONCE = "nonce";
    static final String ACTION_AUTH_RESULT = "com.kii.sdk.photocolle.action.auth.RESULT";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final ViewSwitcher viewSwitcher = new ViewSwitcher((Context)this);
        this.addContentView((View)viewSwitcher, new ViewGroup.LayoutParams(-1, -1));
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        linearLayout.setGravity(17);
        viewSwitcher.addView((View)linearLayout, new ViewGroup.LayoutParams(-1, -1));
        TextView textView = new TextView((Context)this);
        textView.append((CharSequence)"Connecting to authorization server...");
        linearLayout.addView((View)textView, new ViewGroup.LayoutParams(-2, -2));
        ProgressBar progressBar = new ProgressBar((Context)this, null, 16842874);
        progressBar.setVisibility(0);
        linearLayout.addView((View)progressBar, new ViewGroup.LayoutParams(-2, -2));
        WebView webView = new WebView((Context)this);
        viewSwitcher.addView((View)webView, new ViewGroup.LayoutParams(-1, -1));
        webView.getSettings().setCacheMode(2);
        CookieSyncManager.createInstance((Context)this);
        CookieManager.getInstance().removeAllCookie();
        webView.getSettings().setJavaScriptEnabled(true);
        final String state = this.generateState();
        Intent intent = this.getIntent();
        final URL tokenUrl = (URL)intent.getSerializableExtra(KEY_TOKEN_URL);
        final String clientId = intent.getStringExtra(KEY_CLIENT_ID);
        final String clientSecret = intent.getStringExtra(KEY_CLIENT_SECRET);
        final String redirectUri = intent.getStringExtra(KEY_REDIRECT_URI);
        final String nonce = intent.getStringExtra(KEY_NONCE);
        webView.setWebViewClient(new WebViewClient(){
            boolean isFinished = false;

            public void onPageFinished(WebView webView, String url) {
                Uri uri = Uri.parse((String)url);
                if (this.isFinished) {
                    return;
                }
                if (!this.isRedirectUri(Uri.parse((String)redirectUri), uri)) {
                    if (viewSwitcher.getCurrentView() != webView) {
                        viewSwitcher.showNext();
                    }
                    return;
                }
                this.isFinished = true;
                String code = uri.getQueryParameter("code");
                String receivedState = uri.getQueryParameter("state");
                String error = uri.getQueryParameter("error");
                if (!receivedState.equals(state)) {
                    AuthHiddenActivity.this.notifyUnexpecedState(receivedState, state, nonce);
                    return;
                }
                if (error != null) {
                    AuthHiddenActivity.this.notifyError(error, nonce);
                    return;
                }
                if (code == null) {
                    AuthHiddenActivity.this.notifyNullCode(nonce);
                    return;
                }
                AuthHiddenActivity.this.getAccessTokenAsync(tokenUrl, clientId, clientSecret, code, redirectUri, nonce);
                viewSwitcher.showPrevious();
            }

            private boolean isRedirectUri(Uri redirectUri2, Uri uri) {
                if (!redirectUri2.getScheme().equals(uri.getScheme())) {
                    return false;
                }
                if (!redirectUri2.getHost().equals(uri.getHost())) {
                    return false;
                }
                return redirectUri2.getPath().equals(uri.getPath());
            }
        });
        String url = AuthHiddenActivity.generateUrl(((URL)intent.getSerializableExtra(KEY_AUTH_URL)).toString(), clientId, redirectUri, intent.getStringArrayExtra(KEY_SCOPES), state);
        webView.loadUrl(url);
    }

    private void getAccessTokenAsync(final URL tokenUrl, final String clientId, final String clientSecret, final String code, final String redirectUrl, final String nonce) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultHttpClient client = new DefaultHttpClient();
                final Intent intent = AuthHiddenActivity.generateIntent(nonce);
                try {
                    HttpUriRequest request = AuthHiddenActivity.this.createHttpUriRequest(tokenUrl, clientId, clientSecret, code, redirectUrl, nonce);
                    Bundle bundle = (Bundle)client.execute(request, (ResponseHandler)new ResponseHandler<Bundle>(){

                        public Bundle handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                            try {
                                return AuthHiddenActivity.this.parseResponse(response);
                            }
                            catch (HttpException e) {
                                intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)e);
                            }
                            catch (ParseException e) {
                                intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                            }
                            catch (JSONException e) {
                                intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                            }
                            catch (RuntimeException e) {
                                intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                            }
                            return null;
                        }
                    });
                    if (bundle != null) {
                        intent.putExtras(bundle);
                    }
                }
                catch (URISyntaxException e) {
                    intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                }
                catch (UnsupportedEncodingException e) {
                    intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                }
                catch (ClientProtocolException e) {
                    intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ConnectionException((IOException)((Object)e)));
                }
                catch (IOException e) {
                    intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ConnectionException(e));
                }
                catch (RuntimeException e) {
                    intent.putExtra(AuthHiddenActivity.KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(e));
                }
                finally {
                    client.getConnectionManager().shutdown();
                }
                AuthHiddenActivity.this.sendBroadcast(intent);
                AuthHiddenActivity.this.finish();
            }
        }).start();
    }

    private HttpUriRequest createHttpUriRequest(URL tokenUrl, String clientId, String clientSecret, String code, String redirectUrl, String nonce) throws URISyntaxException, UnsupportedEncodingException {
        HttpPost retval = new HttpPost(tokenUrl.toURI());
        ArrayList params = new ArrayList();
        Collections.addAll(params, new BasicNameValuePair("code", code), new BasicNameValuePair("redirect_uri", redirectUrl), new BasicNameValuePair("grant_type", "authorization_code"));
        retval.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        retval.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        retval.setHeader("Authorization", AuthHiddenActivity.createAuthorization(clientId, clientSecret));
        return retval;
    }

    static String createAuthorization(String clientId, String clientSecret) throws UnsupportedEncodingException {
        StringBuilder auth = new StringBuilder();
        auth.append(URLEncoder.encode(clientId, "UTF-8"));
        auth.append(":");
        auth.append(URLEncoder.encode(clientSecret, "UTF-8"));
        return "Basic " + Base64.encodeToString((byte[])auth.toString().getBytes(), (int)2);
    }

    private Bundle parseResponse(HttpResponse response) throws ParseException, JSONException, IOException, HttpException {
        Bundle retval = new Bundle();
        StatusLine statusLine = response.getStatusLine();
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        switch (statusLine.getStatusCode()) {
            case 200: {
                JSONObject json = new JSONObject(body);
                AuthorizationData data = AuthorizationData.create(json);
                if (data != null) {
                    retval.putParcelable(KEY_AUTHORIZATION_DATA, (Parcelable)data);
                    break;
                }
                throw new RuntimeException("no authorization data: " + body);
            }
            case 400: {
                String error = new JSONObject(body).optString("error", null);
                if ("invalid_request".equals(error) || "invalid_grant".equals(error) || "unauthorized_client".equals(error) || "unsupported_grant_type".equals(error) || "invalid_scope".equals(error)) {
                    retval.putString(KEY_ERROR_CODE, error);
                    break;
                }
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
            }
            case 401: {
                String error = new JSONObject(body).optString("error", null);
                if ("invalid_client".equals(error)) {
                    retval.putString(KEY_ERROR_CODE, error);
                    break;
                }
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
            }
            case 500: {
                String error = new JSONObject(body).optString("error", null);
                if ("server_error".equals(error)) {
                    retval.putString(KEY_ERROR_CODE, error);
                    break;
                }
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
            }
            case 503: {
                String error = new JSONObject(body).optString("error", null);
                if ("temporarily_unavailable".equals(error)) {
                    retval.putString(KEY_ERROR_CODE, error);
                    break;
                }
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
            }
            default: {
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
            }
        }
        return retval;
    }

    private void notifyNullCode(String nonce) {
        Intent intent = AuthHiddenActivity.generateIntent(nonce);
        intent.putExtra(KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(new Exception("Server response is invalid: code must not be null")));
        this.sendBroadcast(intent);
        this.finish();
    }

    private void notifyError(String error, String nonce) {
        Intent intent = AuthHiddenActivity.generateIntent(nonce);
        intent.putExtra(KEY_ERROR_CODE, error);
        this.sendBroadcast(intent);
        this.finish();
    }

    private void notifyUnexpecedState(String receivedState, String state, String nonce) {
        Intent intent = AuthHiddenActivity.generateIntent(nonce);
        intent.putExtra(KEY_EXCEPTION, (Serializable)new ResponseBodyParseException(new Exception(String.format("state is unmatched. expected=%s, actual=%s", state, receivedState))));
        this.sendBroadcast(intent);
        this.finish();
    }

    private String generateState() {
        return Long.toString(System.currentTimeMillis());
    }

    private static String generateUrl(String authURL, String clientId, String redirectUri, String[] scopes, String state) {
        StringBuilder scope = new StringBuilder();
        for (String s : scopes) {
            if (scope.length() > 0) {
                scope.append("+");
            }
            scope.append(s);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(authURL).append("?");
        builder.append("client_id=").append(clientId).append("&");
        builder.append("response_type=code&");
        builder.append("redirect_uri=").append(redirectUri).append("&");
        builder.append("scope=").append(scope.toString()).append("&");
        builder.append("state=").append(state);
        return builder.toString();
    }

    private static Intent generateIntent(String nonce) {
        Intent retval = new Intent(ACTION_AUTH_RESULT);
        retval.putExtra(KEY_NONCE, nonce);
        return retval;
    }
}

