/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.content.Context;
import com.kii.sdk.photocolle.ApplicationLayerException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Authority;
import com.kii.sdk.photocolle.CapacityInfo;
import com.kii.sdk.photocolle.Category;
import com.kii.sdk.photocolle.ConnectionException;
import com.kii.sdk.photocolle.ContentBodyInfo;
import com.kii.sdk.photocolle.ContentGUID;
import com.kii.sdk.photocolle.ContentInfo;
import com.kii.sdk.photocolle.ContentThumbnailInfoList;
import com.kii.sdk.photocolle.DataID;
import com.kii.sdk.photocolle.DateFilter;
import com.kii.sdk.photocolle.DetailedContentInfo;
import com.kii.sdk.photocolle.FileType;
import com.kii.sdk.photocolle.GetCapacityInfoCommand;
import com.kii.sdk.photocolle.GetContentBodyInfoCommand;
import com.kii.sdk.photocolle.GetContentDeletionHistoryCommand;
import com.kii.sdk.photocolle.GetContentIDListCommand;
import com.kii.sdk.photocolle.GetContentIDListWithTagsCommand;
import com.kii.sdk.photocolle.GetContentThumbnailInfoCommand;
import com.kii.sdk.photocolle.GetTagIDListCommand;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.ListResponse;
import com.kii.sdk.photocolle.MimeType;
import com.kii.sdk.photocolle.MiscUtils;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.ProjectionType;
import com.kii.sdk.photocolle.ResizeType;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.SortType;
import com.kii.sdk.photocolle.Tag;
import com.kii.sdk.photocolle.TagHead;
import com.kii.sdk.photocolle.UploadContentBodyCommand;
import com.kii.sdk.photocolle.UploadException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoColle {
    URL baseUrl;
    private final AuthenticationContext authenticationContext;

    public PhotoColle(Context androidContext, AuthenticationContext authenticationContext) throws ParameterException {
        if (androidContext == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "androidContext must not be null.");
        }
        if (authenticationContext == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "authenticationContext must not be null.");
        }
        this.baseUrl = MiscUtils.getPhotoColleBaseURL(androidContext);
        this.authenticationContext = authenticationContext;
        MiscUtils.setupLogProperty(androidContext);
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public ListResponse<ContentInfo> getContentIDList(FileType fileType, boolean forDustbox, DateFilter dateFilter, Integer maxResults, Integer start, SortType sortType) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetContentIDListCommand command = new GetContentIDListCommand(this.baseUrl);
        try {
            return (ListResponse)command.execute(new GetContentIDListCommand.Args(this.authenticationContext, fileType, forDustbox, dateFilter, maxResults, start, sortType));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public ListResponse<DetailedContentInfo> getContentIDListWithTags(ProjectionType projectionType, FileType fileType, List<TagHead> criteriaList, boolean forDustbox, DateFilter dateFilter, Integer maxResults, Integer start, SortType sortType) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetContentIDListWithTagsCommand command = new GetContentIDListWithTagsCommand(this.baseUrl);
        try {
            return (ListResponse)command.execute(new GetContentIDListWithTagsCommand.Args(this.authenticationContext, projectionType, fileType, criteriaList, forDustbox, dateFilter, maxResults, start, sortType));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public ListResponse<Tag> getTagIDList(Category category, FileType fileType, Date minDateModified) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetTagIDListCommand command = new GetTagIDListCommand(this.baseUrl);
        try {
            return (ListResponse)command.execute(new GetTagIDListCommand.Args(this.authenticationContext, category, fileType, minDateModified));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public ListResponse<ContentGUID> getContentDeletionHistory(FileType fileType, Date minDateDeleted, Integer maxResults, Integer start) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetContentDeletionHistoryCommand command = new GetContentDeletionHistoryCommand(this.baseUrl);
        try {
            return (ListResponse)command.execute(new GetContentDeletionHistoryCommand.Args(this.authenticationContext, fileType, minDateDeleted, maxResults, start));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public ContentBodyInfo getContentBodyInfo(FileType fileType, ContentGUID contentGUID, ResizeType resizeType) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetContentBodyInfoCommand command = new GetContentBodyInfoCommand(this.baseUrl);
        try {
            return (ContentBodyInfo)command.execute(new GetContentBodyInfoCommand.Args(this.authenticationContext, fileType, contentGUID, resizeType));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public ContentThumbnailInfoList getContentThumbnailInfo(ContentGUID ... contentGUIDs) throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetContentThumbnailInfoCommand command = new GetContentThumbnailInfoCommand(this.baseUrl);
        try {
            return (ContentThumbnailInfoList)command.execute(new GetContentThumbnailInfoCommand.Args(this.authenticationContext, contentGUIDs));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    public DataID uploadContentBody(FileType fileType, String fileName, long size, MimeType mimeType, InputStream bodyStream) throws UploadException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        UploadContentBodyCommand command = new UploadContentBodyCommand(this.baseUrl);
        try {
            DataID dataID = (DataID)command.execute(new UploadContentBodyCommand.Args(this.authenticationContext, fileType, fileName, size, mimeType, bodyStream));
            return dataID;
        }
        catch (ApplicationLayerException e) {
            throw new RuntimeException(e);
        }
        finally {
            MiscUtils.closeQuietly(bodyStream);
        }
    }

    public CapacityInfo getCapacityInfo() throws ApplicationLayerException, ConnectionException, HttpException, ParameterException, ResponseBodyParseException, InvalidTokenException {
        this.refreshToken();
        GetCapacityInfoCommand command = new GetCapacityInfoCommand(this.baseUrl);
        try {
            return (CapacityInfo)command.execute(new GetCapacityInfoCommand.Args(this.authenticationContext));
        }
        catch (UploadException e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshToken() throws ConnectionException, HttpException, InvalidTokenException {
        try {
            Authority.tryToRefreshToken(this.authenticationContext);
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }
}

