/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.annotation.SuppressLint;
import com.kii.sdk.photocolle.ApplicationLayerException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Category;
import com.kii.sdk.photocolle.Command;
import com.kii.sdk.photocolle.EventTag;
import com.kii.sdk.photocolle.FavoriteTag;
import com.kii.sdk.photocolle.FileType;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.ListResponse;
import com.kii.sdk.photocolle.Logic;
import com.kii.sdk.photocolle.MiscUtils;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.PersonTag;
import com.kii.sdk.photocolle.PlacementTag;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.ResponseUtil;
import com.kii.sdk.photocolle.Tag;
import com.kii.sdk.photocolle.YearMonthTag;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"SimpleDateFormat"})
class GetTagIDListLogic
implements Logic<Args, ListResponse<Tag>> {
    private static final URL DEFAULT_URL = Command.toUrl("https://xlb.photocolle-docomo.com/file_a2/2.0/ext/tag_info/get_all");

    GetTagIDListLogic() {
    }

    @Override
    public HttpUriRequest createRequest(URL url, Args arg) {
        try {
            HttpPost retval = new HttpPost(url.toURI());
            Command.signRequest((HttpRequestBase)retval, arg.context);
            JSONObject json = new JSONObject();
            json.put("category", arg.category.getNumber());
            if (arg.fileType != null) {
                json.put("file_type_cd", arg.fileType.getNumber());
            }
            if (arg.minDateModified != null) {
                json.put("min_date_modified", (Object)MiscUtils.formatAsUTC(arg.minDateModified));
            }
            retval.setEntity(Command.generateJSONEntity(json));
            return retval;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListResponse<Tag> parseResponse(HttpResponse response) throws HttpException, ApplicationLayerException, ResponseBodyParseException, InvalidTokenException {
        try {
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                ResponseUtil.throwHttpStatusRelatedException(response);
            }
            JSONObject json = ResponseUtil.newJSONObject(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            int result = ResponseUtil.getInt(json, "result");
            switch (result) {
                case 0: {
                    return GetTagIDListLogic.toListResponse(json);
                }
                case 1: {
                    throw ResponseUtil.newApplicationLayerException(json);
                }
            }
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "result is out of range: " + result);
        }
        catch (IOException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (org.apache.http.ParseException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    private static ListResponse<Tag> toListResponse(JSONObject json) throws ResponseBodyParseException {
        ArrayList<Tag> list = new ArrayList<Tag>();
        list.addAll(GetTagIDListLogic.toPersonTagList(json.optJSONArray("person_tag_list")));
        list.addAll(GetTagIDListLogic.toEventTagList(json.optJSONArray("event_tag_list")));
        list.addAll(GetTagIDListLogic.toFavoriteTagList(json.optJSONArray("optional_tag_list")));
        list.addAll(GetTagIDListLogic.toPlacementTagList(json.optJSONArray("place_info_list")));
        list.addAll(GetTagIDListLogic.toYearMonthTagList(json.optJSONArray("month_info_list")));
        ListResponse<Tag> retval = new ListResponse<Tag>();
        retval.getList().addAll(list);
        return retval;
    }

    private static List<PersonTag> toPersonTagList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PersonTag> retval = new ArrayList<PersonTag>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetTagIDListLogic.toPersonTag(ResponseUtil.getJSONObjectFromArray(array, i), format));
        }
        return retval;
    }

    private static PersonTag toPersonTag(JSONObject json, DateFormat format) throws ResponseBodyParseException {
        try {
            String birth = ResponseUtil.optString(json, "birth_date");
            Date birthDate = birth != null ? format.parse(birth) : null;
            return new PersonTag(ResponseUtil.getContentGUID(json, "person_tag_guid"), ResponseUtil.getString(json, "person_tag_name"), ResponseUtil.getInt(json, "content_cnt"), birthDate);
        }
        catch (ParseException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    private static List<EventTag> toEventTagList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<EventTag> retval = new ArrayList<EventTag>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetTagIDListLogic.toEventTag(ResponseUtil.getJSONObjectFromArray(array, i)));
        }
        return retval;
    }

    private static EventTag toEventTag(JSONObject json) throws ResponseBodyParseException {
        return new EventTag(ResponseUtil.getContentGUID(json, "event_tag_guid"), ResponseUtil.getString(json, "event_tag_name"), ResponseUtil.getInt(json, "content_cnt"));
    }

    private static List<FavoriteTag> toFavoriteTagList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FavoriteTag> retval = new ArrayList<FavoriteTag>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetTagIDListLogic.toFavoriteTag(ResponseUtil.getJSONObjectFromArray(array, i)));
        }
        return retval;
    }

    private static FavoriteTag toFavoriteTag(JSONObject json) throws ResponseBodyParseException {
        return new FavoriteTag(ResponseUtil.getContentGUID(json, "optional_tag_guid"), ResponseUtil.getString(json, "optional_tag_name"), ResponseUtil.getInt(json, "content_cnt"));
    }

    private static List<PlacementTag> toPlacementTagList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PlacementTag> retval = new ArrayList<PlacementTag>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetTagIDListLogic.toPlacementTag(ResponseUtil.getJSONObjectFromArray(array, i)));
        }
        return retval;
    }

    private static PlacementTag toPlacementTag(JSONObject json) throws ResponseBodyParseException {
        return new PlacementTag(ResponseUtil.getContentGUID(json, "place_tag_guid"), ResponseUtil.getString(json, "place_name"), ResponseUtil.getInt(json, "content_cnt"));
    }

    private static List<YearMonthTag> toYearMonthTagList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<YearMonthTag> retval = new ArrayList<YearMonthTag>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetTagIDListLogic.toYearMonthTag(ResponseUtil.getJSONObjectFromArray(array, i)));
        }
        return retval;
    }

    private static YearMonthTag toYearMonthTag(JSONObject json) throws ResponseBodyParseException {
        return new YearMonthTag(ResponseUtil.getContentGUID(json, "month_tag_guid"), ResponseUtil.getString(json, "month_tag_name"), ResponseUtil.getInt(json, "content_cnt"));
    }

    @Override
    public URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    public static class Args {
        public final AuthenticationContext context;
        public final Category category;
        public final FileType fileType;
        public final Date minDateModified;

        public Args(AuthenticationContext context, Category category, FileType fileType, Date minDateModified) {
            if (context == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "context must not be null.");
            }
            if (category == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "category must not be null.");
            }
            this.context = context;
            this.category = category;
            this.fileType = fileType;
            this.minDateModified = minDateModified;
        }
    }
}

