/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.ApplicationLayerException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Command;
import com.kii.sdk.photocolle.ContentGUID;
import com.kii.sdk.photocolle.FileType;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.ListResponse;
import com.kii.sdk.photocolle.Logic;
import com.kii.sdk.photocolle.MiscUtils;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.ResponseUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetContentDeletionHistoryLogic
implements Logic<Args, ListResponse<ContentGUID>> {
    private static final URL DEFAULT_URL = Command.toUrl("https://xlb.photocolle-docomo.com/file_a2/2.0/ext/content/get_delete_history");

    GetContentDeletionHistoryLogic() {
    }

    @Override
    public HttpUriRequest createRequest(URL url, Args arg) {
        try {
            HttpPost retval = new HttpPost(url.toURI());
            Command.signRequest((HttpRequestBase)retval, arg.context);
            JSONObject json = new JSONObject();
            json.put("file_type_cd", arg.fileType.getNumber());
            if (arg.minDateDeleted != null) {
                json.put("min_date_deleted", (Object)MiscUtils.formatAsUTC(arg.minDateDeleted));
            }
            if (arg.maxResults != null) {
                json.put("max_results", arg.maxResults.intValue());
            }
            if (arg.start != null) {
                json.put("start", arg.start.intValue());
            }
            retval.setEntity(Command.generateJSONEntity(json));
            return retval;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListResponse<ContentGUID> parseResponse(HttpResponse response) throws HttpException, ApplicationLayerException, ResponseBodyParseException, InvalidTokenException {
        try {
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                ResponseUtil.throwHttpStatusRelatedException(response);
            }
            JSONObject json = ResponseUtil.newJSONObject(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            int result = ResponseUtil.getInt(json, "result");
            switch (result) {
                case 0: {
                    return GetContentDeletionHistoryLogic.toListResponse(json);
                }
                case 1: {
                    throw ResponseUtil.newApplicationLayerException(json);
                }
            }
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "result is out of range: " + result);
        }
        catch (IOException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParseException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    private static ListResponse<ContentGUID> toListResponse(JSONObject json) throws ResponseBodyParseException {
        ListResponse<ContentGUID> retval = new ListResponse<ContentGUID>(ResponseUtil.getIntInRangeMin(json, "start", 1), ResponseUtil.getIntInRangeMin(json, "next_page", 0), ResponseUtil.getIntInRangeMinMax(json, "content_cnt", 0, 100));
        retval.getList().addAll(GetContentDeletionHistoryLogic.toContentGUIDList(ResponseUtil.getJSONArray(json, "content_list")));
        return retval;
    }

    private static List<ContentGUID> toContentGUIDList(JSONArray array) throws ResponseBodyParseException {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        if (array.length() > 100) {
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("Count of contents of content_list must equal or be lesser than 100 but %d", array.length()));
        }
        ArrayList<ContentGUID> retval = new ArrayList<ContentGUID>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            retval.add(GetContentDeletionHistoryLogic.toContentGUID(ResponseUtil.getStringFromArray(array, i)));
        }
        return retval;
    }

    private static ContentGUID toContentGUID(String guid) throws ResponseBodyParseException {
        try {
            return ResponseUtil.newContentGUIDWithLengthRange(guid, 1, 50);
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    @Override
    public URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    public static class Args {
        public final AuthenticationContext context;
        public final FileType fileType;
        public final Date minDateDeleted;
        public final Integer maxResults;
        public final Integer start;

        public Args(AuthenticationContext context, FileType fileType, Date minDateDeleted, Integer maxResults, Integer start) {
            if (context == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "context must not be null.");
            }
            if (fileType == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "fileType must not be null.");
            }
            if (fileType == FileType.ALL) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "FileType.ALL is unsupported.");
            }
            if (maxResults != null && (maxResults < 1 || maxResults > 100)) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("Value of maxResults is out of range: %d", (int)maxResults));
            }
            if (start != null && start < 1) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("Value of start is out of range: %d", (int)start));
            }
            this.context = context;
            this.fileType = fileType;
            this.minDateDeleted = minDateDeleted;
            this.maxResults = maxResults;
            this.start = start;
        }
    }
}

