/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.ApplicationLayerException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Command;
import com.kii.sdk.photocolle.ContentBodyInfo;
import com.kii.sdk.photocolle.ContentGUID;
import com.kii.sdk.photocolle.FileType;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.Logic;
import com.kii.sdk.photocolle.MimeType;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.ResizeType;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.ResponseUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetContentBodyInfoLogic
implements Logic<Args, ContentBodyInfo> {
    private static final URL DEFAULT_URL = Command.toUrl("https://xlb.photocolle-docomo.com/file_a2/2.0/ext/content/get");

    GetContentBodyInfoLogic() {
    }

    @Override
    public HttpUriRequest createRequest(URL url, Args arg) {
        try {
            HttpPost retval = new HttpPost(url.toURI());
            Command.signRequest((HttpRequestBase)retval, arg.context);
            JSONObject json = new JSONObject();
            json.put("file_type_cd", arg.fileType.getNumber());
            json.put("content_guid", (Object)arg.contentGUID.getString());
            json.put("resize_type_cd", arg.resizeType.getNumber());
            retval.setEntity(Command.generateJSONEntity(json));
            return retval;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ContentBodyInfo parseResponse(HttpResponse response) throws HttpException, ApplicationLayerException, ResponseBodyParseException, InvalidTokenException {
        try {
            HttpEntity entity;
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                ResponseUtil.throwHttpStatusRelatedException(response);
            }
            if ((entity = response.getEntity()).getContentType().getValue().equals("application/json")) {
                JSONObject json = ResponseUtil.newJSONObject(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                int result = ResponseUtil.getInt(json, "result");
                switch (result) {
                    case 1: {
                        throw ResponseUtil.newApplicationLayerException(json);
                    }
                }
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "result is out of range: " + result);
            }
            return this.toContentBodyInfo(entity);
        }
        catch (IOException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParseException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    private ContentBodyInfo toContentBodyInfo(HttpEntity entity) throws ResponseBodyParseException {
        try {
            return new ContentBodyInfo(MimeType.fromString(entity.getContentType().getValue()), new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)entity)));
        }
        catch (ParameterException e) {
            throw new ResponseBodyParseException(e);
        }
        catch (IOException e) {
            throw new ResponseBodyParseException(e);
        }
    }

    @Override
    public URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    public static class Args {
        public final AuthenticationContext context;
        public final FileType fileType;
        public final ContentGUID contentGUID;
        public final ResizeType resizeType;

        public Args(AuthenticationContext context, FileType fileType, ContentGUID contentGUID, ResizeType resizeType) {
            if (context == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "context must not be null.");
            }
            if (fileType == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "fileType must not be null.");
            }
            if (fileType == FileType.ALL) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "FileType.ALL is unsupported.");
            }
            if (contentGUID == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "contentGUID must not be null.");
            }
            if (contentGUID.getString() == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "contentGUID string must not be null.");
            }
            if (contentGUID.getString().length() < 1 || contentGUID.getString().length() > 50) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("contentGUID length is out of range: %d", contentGUID.getString().length()));
            }
            if (resizeType == null) {
                throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "resizeType must not be null.");
            }
            if (resizeType == ResizeType.RESIZED_VIDEO && (fileType == FileType.IMAGE || fileType == FileType.SLIDE_MOVIE)) {
                throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, "This combination of FileType and ResizeType is invalid.");
            }
            this.context = context;
            this.fileType = fileType;
            this.contentGUID = contentGUID;
            this.resizeType = resizeType;
        }
    }
}

