/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.PhotocolleException;

public abstract class BaseApplicationLayerException
extends PhotocolleException {
    private static final long serialVersionUID = 1L;

    BaseApplicationLayerException() {
        super((Throwable)null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorCode {
        PARAMETER_ERROR(100, false),
        TARGET_NOT_FOUND(101, false),
        TIMEOUT(110, true),
        NO_RESULTS(113, false),
        SERVER_ERROR(900, false),
        CONTENTS_DUPLICATED(1101, false),
        CAPACITY_OVER(1102, false),
        FAIL_TO_GET_FREE_SPACE(1103, true),
        FAIL_TO_GET_MAXIMUM_SPACE(1104, true),
        CONTENTS_NOT_FOUND(1105, false),
        MANDATORY_PARAMETER_MISSED(1110, false),
        PARAMETER_SIZE_UNMATCHED(1111, false),
        PARAMETER_TYPE_UNMATCHED(1112, false),
        PARAMETER_VALUE_INVALID(1113, false);

        private static ErrorCode[] errorCodeArray;
        private final int code;
        private final boolean retryable;

        private ErrorCode(int code, boolean retryable) {
            this.code = code;
            this.retryable = retryable;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isRetryable() {
            return this.retryable;
        }

        static ErrorCode toErrorCode(int code) {
            if (errorCodeArray == null) {
                errorCodeArray = ErrorCode.values();
            }
            for (ErrorCode retval : errorCodeArray) {
                if (code != retval.getCode()) continue;
                return retval;
            }
            throw new ParameterException(ParameterException.Reason.OUT_OF_RANGE, String.format("unexpected error code:%d", code));
        }

        static {
            errorCodeArray = null;
        }
    }
}

