/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.kii.sdk.photocolle.AuthHiddenActivity;
import com.kii.sdk.photocolle.AuthenticateCallback;
import com.kii.sdk.photocolle.AuthenticationCanceledException;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.AuthenticationContextAccessException;
import com.kii.sdk.photocolle.AuthenticationContextNotFoundException;
import com.kii.sdk.photocolle.AuthenticationException;
import com.kii.sdk.photocolle.AuthorizationData;
import com.kii.sdk.photocolle.ConnectionException;
import com.kii.sdk.photocolle.HttpException;
import com.kii.sdk.photocolle.InvalidTokenException;
import com.kii.sdk.photocolle.MiscUtils;
import com.kii.sdk.photocolle.NoRefreshTokenException;
import com.kii.sdk.photocolle.ParameterException;
import com.kii.sdk.photocolle.PhotocolleException;
import com.kii.sdk.photocolle.RefreshTokenResult;
import com.kii.sdk.photocolle.ResponseBodyParseException;
import com.kii.sdk.photocolle.Scope;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authority {
    private static final String TAG = "Authority";
    private static final URL DEFAULT_AUTH_URL = MiscUtils.toUrl("https://api.smt.docomo.ne.jp/cgi11d/authorization");
    private static final URL DEFAULT_TOKEN_URL = MiscUtils.toUrl("https://api.smt.docomo.ne.jp/cgi12/token");

    public static void authenticate(final Context context, final String clientId, final String clientSecret, final String redirectUri, final EnumSet<Scope> predefinedScopes, String[] extendedScopes, final String storeKey, final AuthenticateCallback callback) throws ParameterException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must no be null.");
        }
        if (clientId == null) {
            throw ParameterException.nullAssigned("clientId must no be null.");
        }
        if (MiscUtils.isEmptyString(clientId)) {
            throw ParameterException.outOfRange("clientId must no be empty.");
        }
        if (clientSecret == null) {
            throw ParameterException.nullAssigned("clientSecret must no be null.");
        }
        if (MiscUtils.isEmptyString(clientSecret)) {
            throw ParameterException.outOfRange("clientSecret must no be empty.");
        }
        if (redirectUri == null) {
            throw ParameterException.nullAssigned("redirectUri must no be null.");
        }
        if (MiscUtils.isEmptyString(redirectUri)) {
            throw ParameterException.outOfRange("redirectUri must no be empty.");
        }
        if (MiscUtils.isNullOrEmpty(predefinedScopes) && MiscUtils.isNullOrEmpty(extendedScopes)) {
            throw ParameterException.outOfRange("At least, predefinedScopes and/or extendedScopes must not be null or empty.");
        }
        if (MiscUtils.containsNullOrEmpty(extendedScopes)) {
            throw ParameterException.outOfRange("extendedScopes must not contain null or empty.");
        }
        if (callback == null) {
            throw ParameterException.nullAssigned("callback must no be null.");
        }
        final HashSet<String> extendedScopesSet = new HashSet<String>();
        if (extendedScopes != null) {
            for (String scope : extendedScopes) {
                if (extendedScopesSet.contains(scope)) continue;
                extendedScopesSet.add(scope);
            }
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Authority.authenticateInner(context, clientId, clientSecret, redirectUri, predefinedScopes, extendedScopesSet, storeKey, callback);
            }
        });
        thread.start();
    }

    public static void refreshToken(final AuthenticationContext authenticationContext, final AuthenticateCallback callback) throws ParameterException {
        if (authenticationContext == null) {
            throw ParameterException.nullAssigned("authenticationContext must no be null.");
        }
        if (TextUtils.isEmpty((CharSequence)authenticationContext.getClientId()) || TextUtils.isEmpty((CharSequence)authenticationContext.getClientSecret())) {
            throw ParameterException.outOfRange("AuthenticateContext which loaded by deprecated loadBy method can't refresh.");
        }
        if (callback == null) {
            throw ParameterException.nullAssigned("callback must no be null.");
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Context context = authenticationContext.getAppContext();
                try {
                    Authority.refreshTokenInner(authenticationContext);
                    Authority.postToMainLooper(context, callback, authenticationContext, null);
                }
                catch (NoRefreshTokenException e) {
                    Authority.postToMainLooper(context, callback, null, e);
                }
                catch (HttpException e) {
                    Authority.postToMainLooper(context, callback, null, e);
                }
                catch (InvalidTokenException e) {
                    Authority.postToMainLooper(context, callback, null, e);
                }
                catch (ResponseBodyParseException e) {
                    Authority.postToMainLooper(context, callback, null, e);
                }
                catch (ConnectionException e) {
                    Authority.postToMainLooper(context, callback, null, e);
                }
            }
        });
        thread.start();
    }

    private static void refreshTokenInner(AuthenticationContext context) throws NoRefreshTokenException, ResponseBodyParseException, InvalidTokenException, HttpException, ConnectionException {
        if (context.canRefreshToken()) {
            try {
                Authority.refreshToken(context);
            }
            catch (UnsupportedEncodingException e) {
                throw new ResponseBodyParseException(e);
            }
            catch (IOException e) {
                throw new ConnectionException(e);
            }
            return;
        }
        throw new NoRefreshTokenException("AuthenticationContext can't refresh.");
    }

    private static void postToMainLooper(Context context, final AuthenticateCallback callback, final AuthenticationContext authContext, final Exception exception) {
        new Handler(context.getMainLooper()).post(new Runnable(){

            public void run() {
                callback.onAuthenticated(authContext, exception);
            }
        });
    }

    private static void authenticateInner(Context context, final String clientId, final String clientSecret, String redirectUri, EnumSet<Scope> predefinedScopes, Set<String> extendedScopes, final String storeKey, final AuthenticateCallback callback) {
        if (Authority.tryToUseStoredAuthenticationContext(context, clientId, clientSecret, storeKey, callback)) {
            return;
        }
        Bundle authData = Authority.generateAuthData(context, clientId, clientSecret, redirectUri, predefinedScopes, extendedScopes);
        final String nonce = Authority.generateNonce(context);
        authData.putString("nonce", nonce);
        IntentFilter filter = new IntentFilter("com.kii.sdk.photocolle.action.auth.RESULT");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (!this.isMyIntent(intent)) {
                    return;
                }
                context.unregisterReceiver((BroadcastReceiver)this);
                Exception exception = (Exception)intent.getSerializableExtra("exception");
                if (exception != null) {
                    callback.onAuthenticated(null, exception);
                    return;
                }
                String errorCode = intent.getStringExtra("errorCode");
                if (errorCode != null) {
                    callback.onAuthenticated(null, Authority.toAuthenticationException(errorCode));
                    return;
                }
                AuthorizationData data = (AuthorizationData)intent.getParcelableExtra("authorizationData");
                if (data != null) {
                    AuthenticationContext authContext = new AuthenticationContext(context, data.accessToken, data.expiredDate, data.refreshToken, storeKey, clientId, clientSecret);
                    try {
                        authContext.save();
                    }
                    catch (AuthenticationContextAccessException e) {
                        Log.v((String)Authority.TAG, (String)"save is failed.", (Throwable)e);
                    }
                    callback.onAuthenticated(authContext, null);
                    return;
                }
                throw new RuntimeException("Unexpected state.");
            }

            private boolean isMyIntent(Intent intent) {
                if (!"com.kii.sdk.photocolle.action.auth.RESULT".equals(intent.getAction())) {
                    return false;
                }
                return nonce.equals(intent.getStringExtra("nonce"));
            }
        }, filter);
        Intent intent = new Intent(context, AuthHiddenActivity.class);
        intent.putExtras(authData);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    private static boolean tryToUseStoredAuthenticationContext(Context context, String clientId, String clientSecret, String storeKey, final AuthenticateCallback callback) {
        boolean retval = false;
        if (!TextUtils.isEmpty((CharSequence)storeKey)) {
            try {
                if (AuthenticationContext.hasSaved(context, storeKey)) {
                    final AuthenticationContext authContext = AuthenticationContext.loadFrom(context, storeKey, clientId, clientSecret);
                    RefreshTokenResult result = Authority.tryToRefreshToken(authContext);
                    switch (result) {
                        case ISNOT_EXPIRED: 
                        case REFRESHED: {
                            new Handler(context.getMainLooper()).post(new Runnable(){

                                public void run() {
                                    callback.onAuthenticated(authContext, null);
                                }
                            });
                            retval = true;
                            break;
                        }
                        case EXPIRED_BUT_CANNOT_REFRESH: {
                            retval = false;
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"refreshToken failed:", (Throwable)e);
            }
            catch (HttpException e) {
                Log.e((String)TAG, (String)"refreshToken failed:", (Throwable)e);
            }
            catch (AuthenticationContextAccessException e) {
            }
            catch (AuthenticationContextNotFoundException e) {
            }
            catch (InvalidTokenException e) {
                // empty catch block
            }
        }
        return retval;
    }

    private static Bundle generateAuthData(Context context, String clientId, String clientSecret, String redirectUri, EnumSet<Scope> predefinedScopes, Set<String> extendedScopes) {
        if (context == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "context must no be null.");
        }
        if (clientId == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "clientId must no be null.");
        }
        if (clientSecret == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "clientSecret must no be null.");
        }
        if (redirectUri == null) {
            throw new ParameterException(ParameterException.Reason.NULL_ASSIGNED, "redirectUri must no be null.");
        }
        if (MiscUtils.isNullOrEmpty(predefinedScopes) && MiscUtils.isNullOrEmpty(extendedScopes)) {
            throw ParameterException.outOfRange("At least, predefinedScopes and/or extendedScopes must not be null or empty.");
        }
        if (MiscUtils.containsNullOrEmpty(extendedScopes)) {
            throw ParameterException.outOfRange("extendedScopes must not contain null or empty.");
        }
        String path = Uri.parse((String)redirectUri).getPath();
        if (path != null && path.length() == 0) {
            redirectUri = redirectUri + "/";
        }
        HashSet<String> scopes = new HashSet<String>();
        if (predefinedScopes != null) {
            for (Scope scope : predefinedScopes) {
                scopes.add(scope.getLabel());
            }
        }
        if (extendedScopes != null) {
            for (String string : extendedScopes) {
                if (TextUtils.isEmpty((CharSequence)string) || scopes.contains(string)) continue;
                scopes.add(string);
            }
        }
        Bundle retval = new Bundle();
        retval.putSerializable("authUrl", (Serializable)Authority.getAuthURL(context));
        retval.putSerializable("tokenUrl", (Serializable)Authority.getTokenURL(context));
        retval.putString("clientId", clientId);
        retval.putString("clientSecret", clientSecret);
        retval.putString("redirectUri", redirectUri);
        retval.putStringArray("scopes", scopes.toArray(new String[0]));
        return retval;
    }

    static RefreshTokenResult tryToRefreshToken(AuthenticationContext context) throws ClientProtocolException, UnsupportedEncodingException, IOException, HttpException, InvalidTokenException {
        if (!context.isTokenExpired()) {
            return RefreshTokenResult.ISNOT_EXPIRED;
        }
        if (!context.canRefreshToken()) {
            return RefreshTokenResult.EXPIRED_BUT_CANNOT_REFRESH;
        }
        Authority.refreshToken(context);
        return RefreshTokenResult.REFRESHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshToken(AuthenticationContext context) throws ClientProtocolException, UnsupportedEncodingException, IOException, HttpException, InvalidTokenException {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            final ArrayList exceptions = new ArrayList(1);
            AuthorizationData data = (AuthorizationData)client.execute(Authority.createRefreshTokenRequest(context), (ResponseHandler)new ResponseHandler<AuthorizationData>(){

                public AuthorizationData handleResponse(HttpResponse response) {
                    AuthorizationData retval = null;
                    try {
                        retval = Authority.parseRefreshTokenResponse(response);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                    return retval;
                }
            });
            if (!exceptions.isEmpty()) {
                Exception exception = (Exception)exceptions.get(0);
                if (exception instanceof HttpException) {
                    throw (HttpException)exception;
                }
                if (exception instanceof InvalidTokenException) {
                    throw (InvalidTokenException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                Log.e((String)TAG, (String)"unsupported exception:", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            context.update(data);
            context.save();
        }
        catch (AuthenticationContextAccessException e) {
            Log.v((String)TAG, (String)"save is failed.", (Throwable)e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static HttpUriRequest createRefreshTokenRequest(AuthenticationContext context) throws UnsupportedEncodingException {
        HttpPost retval = new HttpPost(Authority.getTokenURL(context.getAppContext()).toString());
        ArrayList params = new ArrayList();
        Collections.addAll(params, new BasicNameValuePair("grant_type", "refresh_token"), new BasicNameValuePair("refresh_token", context.getRefreshToken()));
        retval.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        retval.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        retval.setHeader("Authorization", AuthHiddenActivity.createAuthorization(context.getClientId(), context.getClientSecret()));
        return retval;
    }

    private static AuthorizationData parseRefreshTokenResponse(HttpResponse response) throws IOException, HttpException, InvalidTokenException {
        StatusLine statusLine = response.getStatusLine();
        String body = null;
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            switch (statusLine.getStatusCode()) {
                case 200: {
                    JSONObject json = new JSONObject(body);
                    AuthorizationData data = AuthorizationData.create(json);
                    if (data != null) {
                        return data;
                    }
                    throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
                }
                case 400: {
                    String error = new JSONObject(body).optString("error", null);
                    if (!"invalid_grant".equals(error)) break;
                    throw new InvalidTokenException();
                }
            }
            throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
        }
        catch (ParseException e) {
            throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
        }
        catch (JSONException e) {
            throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), body);
        }
    }

    private static String generateNonce(Context context) {
        return context.getApplicationContext().getPackageName() + "." + Long.toString(System.currentTimeMillis());
    }

    private static URL getTokenURL(Context context) {
        return Authority.getURL(MiscUtils.getTokenBaseURL(context), DEFAULT_TOKEN_URL);
    }

    private static URL getAuthURL(Context context) {
        return Authority.getURL(MiscUtils.getAuthorityBaseURL(context), DEFAULT_AUTH_URL);
    }

    private static URL getURL(URL baseURL, URL defaultURL) {
        try {
            if (baseURL == null) {
                return defaultURL;
            }
            return new URL(baseURL, defaultURL.getFile());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static PhotocolleException toAuthenticationException(String errorCode) {
        if (errorCode.equals("access_denied")) {
            return new AuthenticationCanceledException();
        }
        return new AuthenticationException(AuthenticationException.Reason.toReason(errorCode), null);
    }
}

