/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import com.kii.sdk.photocolle.PhotocolleException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationException
extends PhotocolleException {
    private static final long serialVersionUID = 1L;
    private final Reason reason;
    private final Map<String, String> detail;

    AuthenticationException(Reason reason, Map<String, String> detail) {
        super(AuthenticationException.createMessage(reason, detail));
        this.reason = reason;
        this.detail = detail;
    }

    private static String createMessage(Reason reason, Map<String, String> detail) {
        JSONObject json = new JSONObject();
        try {
            json.put("className", (Object)"AuthenticationException");
            json.put("reason", (Object)reason.label);
            if (detail != null) {
                json.put("detail", (Object)new JSONObject(detail));
            }
            return json.toString(4);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Reason getReason() {
        return this.reason;
    }

    public Map<String, String> getDetail() {
        return this.detail;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        INVALID_REQUEST("invalid_request"),
        UNSUPPORTED_RESPONSE_TYPE("unsupported_response_type"),
        SERVER_ERROR("server_error"),
        INVALID_GRANT("invalid_grant"),
        INVALID_CLIENT("invalid_client"),
        UNAUTHORIZED_CLIENT("unauthorized_client"),
        UNSUPPORTED_GRANT_TYPE("unsupported_grant_type"),
        INVALID_SCOPE("invalid_scope"),
        TEMPORARILY_UNAVAILABLE("temporarily_unavailable");

        private static Reason[] reasons;
        private final String label;

        private Reason(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        static Reason toReason(String label) {
            if (reasons == null) {
                reasons = Reason.values();
            }
            for (Reason retval : reasons) {
                if (!label.equals(retval.getLabel())) continue;
                return retval;
            }
            throw new IllegalArgumentException(String.format("unexpected reason:%s", label));
        }

        static {
            reasons = null;
        }
    }
}

