/*
 * Decompiled with CFR 0.152.
 */
package com.kii.sdk.photocolle;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.kii.sdk.photocolle.AuthenticationContextAccessException;
import com.kii.sdk.photocolle.AuthenticationContextNotFoundException;
import com.kii.sdk.photocolle.AuthorizationData;
import com.kii.sdk.photocolle.MiscUtils;
import com.kii.sdk.photocolle.ParameterException;
import java.util.concurrent.TimeUnit;

public class AuthenticationContext {
    private static final String PHOTOCOLLE_PREF = "photocollePref";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String EXPIRED_DATE = "expiredDate";
    private static final String REFRESH_TOKEN = "refreshToken";
    private final Context appContext;
    private String accessToken;
    private long expiredDate;
    private String refreshToken;
    private String storeKey;
    private final String clientId;
    private final String clientSecret;

    AuthenticationContext(Context context, String accessToken, long expiredDate, String refreshToken, String storeKey, String clientId, String clientSecret) {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (accessToken == null) {
            throw ParameterException.nullAssigned("accessToken must not be null.");
        }
        if (MiscUtils.isEmptyString(accessToken)) {
            throw ParameterException.outOfRange("accessToken must not be empty.");
        }
        if (expiredDate <= 0L) {
            throw ParameterException.outOfRange("expiredDate must be positive.");
        }
        if (clientId == null) {
            throw ParameterException.nullAssigned("clientId must not be null.");
        }
        if (MiscUtils.isEmptyString(clientId)) {
            throw ParameterException.outOfRange("clientId must not be empty.");
        }
        if (clientSecret == null) {
            throw ParameterException.nullAssigned("clientSecret must not be null.");
        }
        if (MiscUtils.isEmptyString(clientSecret)) {
            throw ParameterException.outOfRange("clientSecret must not be empty.");
        }
        this.appContext = context.getApplicationContext();
        this.accessToken = accessToken;
        this.expiredDate = expiredDate;
        this.refreshToken = refreshToken;
        this.storeKey = storeKey;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    private AuthenticationContext(Context context, String accessToken, long expiredDate, String refreshToken, String storeKey) {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null");
        }
        if (accessToken == null) {
            throw ParameterException.nullAssigned("accessToken must not be null");
        }
        if (MiscUtils.isEmptyString(accessToken)) {
            throw ParameterException.outOfRange("accessToken must not be empty.");
        }
        if (expiredDate <= 0L) {
            throw ParameterException.outOfRange("expiredDate must be positive.");
        }
        this.appContext = context.getApplicationContext();
        this.accessToken = accessToken;
        this.expiredDate = expiredDate;
        this.refreshToken = refreshToken;
        this.storeKey = storeKey;
        this.clientId = null;
        this.clientSecret = null;
    }

    public static boolean hasSaved(Context context, String key) throws AuthenticationContextAccessException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (key == null) {
            throw ParameterException.nullAssigned("key must not be null.");
        }
        if (MiscUtils.isEmptyString(key)) {
            throw ParameterException.outOfRange("key must not be empty.");
        }
        String accessToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, ACCESS_TOKEN), null);
        long expiredDate = AuthenticationContext.getSharedPreferences(context).getLong(AuthenticationContext.getKey(key, EXPIRED_DATE), 0L);
        String refreshToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, REFRESH_TOKEN), null);
        return accessToken != null && expiredDate != 0L;
    }

    @Deprecated
    public static AuthenticationContext loadFrom(Context context, String key) throws AuthenticationContextAccessException, AuthenticationContextNotFoundException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (key == null) {
            throw ParameterException.nullAssigned("key must not be null.");
        }
        if (MiscUtils.isEmptyString(key)) {
            throw ParameterException.outOfRange("key must not be empty.");
        }
        String accessToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, ACCESS_TOKEN), null);
        long expiredDate = AuthenticationContext.getSharedPreferences(context).getLong(AuthenticationContext.getKey(key, EXPIRED_DATE), 0L);
        String refreshToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, REFRESH_TOKEN), null);
        if (accessToken == null || expiredDate == 0L) {
            throw new AuthenticationContextNotFoundException();
        }
        return new AuthenticationContext(context, accessToken, expiredDate, refreshToken, key);
    }

    private static AuthenticationContext load(Context context, String key, String clientId, String clientSecret) throws AuthenticationContextAccessException, AuthenticationContextNotFoundException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (key == null) {
            throw ParameterException.nullAssigned("key must not be null.");
        }
        if (MiscUtils.isEmptyString(key)) {
            throw ParameterException.outOfRange("key must not be empty.");
        }
        String accessToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, ACCESS_TOKEN), null);
        long expiredDate = AuthenticationContext.getSharedPreferences(context).getLong(AuthenticationContext.getKey(key, EXPIRED_DATE), 0L);
        String refreshToken = AuthenticationContext.getSharedPreferences(context).getString(AuthenticationContext.getKey(key, REFRESH_TOKEN), null);
        if (accessToken == null || expiredDate == 0L) {
            throw new AuthenticationContextNotFoundException();
        }
        return new AuthenticationContext(context, accessToken, expiredDate, refreshToken, key, clientId, clientSecret);
    }

    public static AuthenticationContext loadFrom(Context context, String key, String clientId, String clientSecret) throws AuthenticationContextAccessException, AuthenticationContextNotFoundException {
        if (clientId == null) {
            throw ParameterException.nullAssigned("clientId must not be null.");
        }
        if (MiscUtils.isEmptyString(clientId)) {
            throw ParameterException.outOfRange("clientId must not be empty.");
        }
        if (clientSecret == null) {
            throw ParameterException.nullAssigned("clientSecret must not be null.");
        }
        if (MiscUtils.isEmptyString(clientSecret)) {
            throw ParameterException.outOfRange("clientSecret must not be empty.");
        }
        return AuthenticationContext.load(context, key, clientId, clientSecret);
    }

    public static void removeFrom(Context context, String key) throws AuthenticationContextAccessException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (key == null) {
            throw ParameterException.nullAssigned("key must not be null.");
        }
        if (MiscUtils.isEmptyString(key)) {
            throw ParameterException.outOfRange("key must not be empty.");
        }
        SharedPreferences.Editor editor = AuthenticationContext.getSharedPreferences(context).edit();
        editor.remove(AuthenticationContext.getKey(key, ACCESS_TOKEN));
        editor.remove(AuthenticationContext.getKey(key, EXPIRED_DATE));
        editor.remove(AuthenticationContext.getKey(key, REFRESH_TOKEN));
        if (!editor.commit()) {
            throw new AuthenticationContextAccessException(AuthenticationContextAccessException.Reason.ACCESS_FAILED);
        }
    }

    public static void removeAll(Context context) throws AuthenticationContextAccessException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        SharedPreferences.Editor editor = AuthenticationContext.getSharedPreferences(context).edit();
        editor.clear();
        if (!editor.commit()) {
            throw new AuthenticationContextAccessException(AuthenticationContextAccessException.Reason.ACCESS_FAILED);
        }
    }

    public void saveTo(Context context, String key) throws AuthenticationContextAccessException {
        if (context == null) {
            throw ParameterException.nullAssigned("context must not be null.");
        }
        if (key == null) {
            throw ParameterException.nullAssigned("key must not be null.");
        }
        if (MiscUtils.isEmptyString(key)) {
            throw ParameterException.outOfRange("key must not be empty.");
        }
        if (!TextUtils.isEmpty((CharSequence)this.storeKey) && !this.storeKey.equals(key) && AuthenticationContext.hasSaved(context, this.storeKey)) {
            AuthenticationContext.removeFrom(context, this.storeKey);
        }
        this.storeKey = key;
        this.saveToSharedPreferences(context, key);
    }

    public long getRemainingTime(TimeUnit timeUnit) throws ParameterException {
        if (timeUnit == null) {
            throw ParameterException.nullAssigned("timeUnit must not be null.");
        }
        return timeUnit.convert(this.expiredDate - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    void save() throws AuthenticationContextAccessException {
        if (!TextUtils.isEmpty((CharSequence)this.storeKey)) {
            this.saveToSharedPreferences(this.appContext, this.storeKey);
        }
    }

    private void saveToSharedPreferences(Context context, String key) throws AuthenticationContextAccessException {
        SharedPreferences.Editor editor = AuthenticationContext.getSharedPreferences(context).edit();
        editor.putString(AuthenticationContext.getKey(key, ACCESS_TOKEN), this.accessToken);
        editor.putLong(AuthenticationContext.getKey(key, EXPIRED_DATE), this.expiredDate);
        if (TextUtils.isEmpty((CharSequence)this.refreshToken)) {
            editor.remove(AuthenticationContext.getKey(key, REFRESH_TOKEN));
        } else {
            editor.putString(AuthenticationContext.getKey(key, REFRESH_TOKEN), this.refreshToken);
        }
        if (!editor.commit()) {
            throw new AuthenticationContextAccessException(AuthenticationContextAccessException.Reason.ACCESS_FAILED);
        }
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        Context appContext = context.getApplicationContext();
        StringBuilder builder = new StringBuilder();
        builder.append(appContext.getPackageName()).append('.').append(PHOTOCOLLE_PREF);
        return appContext.getSharedPreferences(builder.toString(), 0);
    }

    private static String getKey(String keyBase, String keySpecific) {
        return keyBase + '.' + keySpecific;
    }

    boolean isTokenExpired() {
        return this.expiredDate - 10000L < System.currentTimeMillis();
    }

    void update(AuthorizationData data) {
        this.accessToken = data.accessToken;
        this.expiredDate = data.expiredDate;
        this.refreshToken = data.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    long getExpiredDate() {
        return this.expiredDate;
    }

    String getRefreshToken() {
        return this.refreshToken;
    }

    Context getAppContext() {
        return this.appContext;
    }

    String getClientId() {
        return this.clientId;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    boolean canRefreshToken() {
        if (TextUtils.isEmpty((CharSequence)this.clientId) || TextUtils.isEmpty((CharSequence)this.clientSecret)) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)this.refreshToken);
    }
}

