/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.services;

import android.support.annotation.NonNull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.scribe.kii.exceptions.OAuthSignatureException;
import org.scribe.kii.services.Base64Encoder;
import org.scribe.kii.services.SignatureService;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class HMACSha1SignatureService
implements SignatureService {
    private static final String EMPTY_STRING = "";
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final String UTF8 = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String METHOD = "HMAC-SHA1";

    @Override
    @NonNull
    public String getSignature(@NonNull String baseString, @NonNull String apiSecret, @NonNull String tokenSecret) {
        try {
            Preconditions.checkEmptyString(baseString, "Base string cant be null or empty string");
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return this.doSign(baseString, OAuthEncoder.encode(apiSecret) + '&' + OAuthEncoder.encode(tokenSecret));
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    private String doSign(String toSign, String keyString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(UTF8), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] bytes = mac.doFinal(toSign.getBytes(UTF8));
        return this.bytesToBase64String(bytes).replace(CARRIAGE_RETURN, EMPTY_STRING);
    }

    private String bytesToBase64String(byte[] bytes) {
        return Base64Encoder.getInstance().encode(bytes);
    }

    @Override
    @NonNull
    public String getSignatureMethod() {
        return METHOD;
    }
}

