/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.oauth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.scribe.kii.builder.api.DefaultApi20;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.model.OAuthRequest;
import org.scribe.kii.model.Response;
import org.scribe.kii.model.Token;
import org.scribe.kii.model.Verifier;
import org.scribe.kii.oauth.OAuthService;

public class OAuth20ServiceImpl
implements OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;
    private final OAuthConfig config;

    public OAuth20ServiceImpl(@NonNull DefaultApi20 api, @NonNull OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    @Override
    @NonNull
    public Token getAccessToken(@Nullable Token requestToken, @NonNull Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addQuerystringParameter("client_id", this.config.getApiKey());
        request.addQuerystringParameter("client_secret", this.config.getApiSecret());
        request.addQuerystringParameter("code", verifier.getValue());
        request.addQuerystringParameter("redirect_uri", this.config.getCallback());
        if (this.config.hasScope()) {
            request.addQuerystringParameter("scope", this.config.getScope());
        }
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    @Nullable
    public Token getRequestToken() {
        throw new UnsupportedOperationException("Unsupported operation, please use 'getAuthorizationUrl' and redirect your users there");
    }

    @Override
    @NonNull
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signRequest(@NonNull Token accessToken, @NonNull OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@Nullable Token requestToken) {
        return this.api.getAuthorizationUrl(this.config);
    }
}

