/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.utils.StreamUtils;

public class Response {
    private static final String EMPTY = "";
    private int code;
    private String message;
    private String body;
    private InputStream stream;
    private Map<String, String> headers;

    Response(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
            this.code = connection.getResponseCode();
            this.message = connection.getResponseMessage();
            this.headers = this.parseHeaders(connection);
            this.stream = this.isSuccessful() ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (UnknownHostException e) {
            throw new OAuthException("The IP address of a host could not be determined.", e);
        }
    }

    private String parseBodyContents() {
        this.body = StreamUtils.getStreamContents(this.getStream());
        return this.body;
    }

    private Map<String, String> parseHeaders(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : conn.getHeaderFields().keySet()) {
            headers.put(key, conn.getHeaderFields().get(key).get(0));
        }
        return headers;
    }

    public boolean isSuccessful() {
        return this.getCode() >= 200 && this.getCode() < 400;
    }

    @NonNull
    public String getBody() {
        return this.body != null ? this.body : this.parseBodyContents();
    }

    @NonNull
    public InputStream getStream() {
        return this.stream;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getHeader(@NonNull String name) {
        return this.headers.get(name);
    }
}

