/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.OutputStream;
import org.scribe.kii.model.SignatureType;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final SignatureType signatureType;
    private final String scope;
    private final OutputStream debugStream;

    public OAuthConfig(@NonNull String key, @NonNull String secret) {
        this(key, secret, null, null, null, null);
    }

    public OAuthConfig(@NonNull String key, @NonNull String secret, @Nullable String callback, @Nullable SignatureType type, @Nullable String scope, @Nullable OutputStream stream) {
        this.apiKey = key;
        this.apiSecret = secret;
        this.callback = callback;
        this.signatureType = type;
        this.scope = scope;
        this.debugStream = stream;
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    @NonNull
    public String getApiSecret() {
        return this.apiSecret;
    }

    @Nullable
    public String getCallback() {
        return this.callback;
    }

    @Nullable
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public void log(@NonNull String message) {
        if (this.debugStream != null) {
            message = message + "\n";
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (Exception e) {
                throw new RuntimeException("there were problems while writting to the debug stream", e);
            }
        }
    }
}

