/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.extractors;

import android.support.annotation.NonNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.extractors.RequestTokenExtractor;
import org.scribe.kii.model.Token;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class TokenExtractorImpl
implements RequestTokenExtractor,
AccessTokenExtractor {
    private static final Pattern TOKEN_REGEX = Pattern.compile("oauth_token=([^&]+)");
    private static final Pattern SECRET_REGEX = Pattern.compile("oauth_token_secret=([^&]*)");

    @Override
    @NonNull
    public Token extract(@NonNull String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extract(response, TOKEN_REGEX);
        String secret = this.extract(response, SECRET_REGEX);
        return new Token(token, secret, response);
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }
}

