/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi10a;
import org.scribe.kii.model.Token;

public class TwitterApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://api.twitter.com/oauth/authorize?oauth_token=%s";
    private static final String REQUEST_TOKEN_RESOURCE = "api.twitter.com/oauth/request_token";
    private static final String ACCESS_TOKEN_RESOURCE = "api.twitter.com/oauth/access_token";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://api.twitter.com/oauth/access_token";
    }

    @Override
    @NonNull
    public String getRequestTokenEndpoint() {
        return "https://api.twitter.com/oauth/request_token";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull Token requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    public static class Authorize
    extends SSL {
    }

    public static class Authenticate
    extends SSL {
        private static final String AUTHENTICATE_URL = "https://api.twitter.com/oauth/authenticate?oauth_token=%s";

        @Override
        @NonNull
        public String getAuthorizationUrl(@NonNull Token requestToken) {
            return String.format(AUTHENTICATE_URL, requestToken.getToken());
        }
    }

    public static class SSL
    extends TwitterApi {
        @Override
        @NonNull
        public String getAccessTokenEndpoint() {
            return "https://api.twitter.com/oauth/access_token";
        }

        @Override
        @NonNull
        public String getRequestTokenEndpoint() {
            return "https://api.twitter.com/oauth/request_token";
        }
    }
}

