/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi10a;
import org.scribe.kii.model.Token;

public class PlurkApi
extends DefaultApi10a {
    private static final String REQUEST_TOKEN_URL = "http://www.plurk.com/OAuth/request_token";
    private static final String AUTHORIZATION_URL = "http://www.plurk.com/OAuth/authorize?oauth_token=%s";
    private static final String ACCESS_TOKEN_URL = "http://www.plurk.com/OAuth/access_token";

    @Override
    @NonNull
    public String getRequestTokenEndpoint() {
        return REQUEST_TOKEN_URL;
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    public static class Mobile
    extends PlurkApi {
        private static final String AUTHORIZATION_URL = "http://www.plurk.com/m/authorize?oauth_token=%s";

        @Override
        @NonNull
        public String getAuthorizationUrl(@NonNull Token requestToken) {
            return String.format(AUTHORIZATION_URL, requestToken.getToken());
        }
    }
}

