/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi20;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.extractors.JsonTokenExtractor;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class LiveApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://oauth.live.com/authorize?client_id=%s&redirect_uri=%s&response_type=code";
    private static final String SCOPED_AUTHORIZE_URL = "https://oauth.live.com/authorize?client_id=%s&redirect_uri=%s&response_type=code&scope=%s";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://oauth.live.com/token?grant_type=authorization_code";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull OAuthConfig config) {
        Preconditions.checkValidUrl(config.getCallback(), "Must provide a valid url as callback. Live does not support OOB");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()), OAuthEncoder.encode(config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()));
    }

    @Override
    @NonNull
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }
}

