/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.scribe.kii.builder.api.DefaultApi10a;
import org.scribe.kii.model.Token;

public class LinkedInApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://api.linkedin.com/uas/oauth/authenticate?oauth_token=%s";
    private static final String REQUEST_TOKEN_URL = "https://api.linkedin.com/uas/oauth/requestToken";
    private final Set<String> scopes;

    public LinkedInApi() {
        this.scopes = Collections.emptySet();
    }

    public LinkedInApi(@NonNull Set<String> scopes) {
        this.scopes = Collections.unmodifiableSet(scopes);
    }

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://api.linkedin.com/uas/oauth/accessToken";
    }

    @Override
    @NonNull
    public String getRequestTokenEndpoint() {
        return this.scopes.isEmpty() ? REQUEST_TOKEN_URL : "https://api.linkedin.com/uas/oauth/requestToken?scope=" + this.scopesAsString();
    }

    private String scopesAsString() {
        StringBuilder builder = new StringBuilder();
        for (String scope : this.scopes) {
            builder.append("+" + scope);
        }
        return builder.substring(1);
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull Token requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    @NonNull
    public static LinkedInApi withScopes(String ... scopes) {
        HashSet<String> scopeSet = new HashSet<String>(Arrays.asList(scopes));
        return new LinkedInApi(scopeSet);
    }
}

