/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi20;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class FacebookApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://www.facebook.com/dialog/oauth?client_id=%s&redirect_uri=%s";
    private static final String SCOPED_AUTHORIZE_URL = "https://www.facebook.com/dialog/oauth?client_id=%s&redirect_uri=%s&scope=%s";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://graph.facebook.com/oauth/access_token";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull OAuthConfig config) {
        Preconditions.checkValidUrl(config.getCallback(), "Must provide a valid url as callback. Facebook does not support OOB");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()), OAuthEncoder.encode(config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()));
    }
}

