/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.Api;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.extractors.BaseStringExtractor;
import org.scribe.kii.extractors.BaseStringExtractorImpl;
import org.scribe.kii.extractors.HeaderExtractor;
import org.scribe.kii.extractors.HeaderExtractorImpl;
import org.scribe.kii.extractors.RequestTokenExtractor;
import org.scribe.kii.extractors.TokenExtractorImpl;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.model.Token;
import org.scribe.kii.model.Verb;
import org.scribe.kii.oauth.OAuth10aServiceImpl;
import org.scribe.kii.oauth.OAuthService;
import org.scribe.kii.services.HMACSha1SignatureService;
import org.scribe.kii.services.SignatureService;
import org.scribe.kii.services.TimestampService;
import org.scribe.kii.services.TimestampServiceImpl;

public abstract class DefaultApi10a
implements Api {
    @NonNull
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new TokenExtractorImpl();
    }

    @NonNull
    public BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    @NonNull
    public HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    @NonNull
    public RequestTokenExtractor getRequestTokenExtractor() {
        return new TokenExtractorImpl();
    }

    @NonNull
    public SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    @NonNull
    public TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    @NonNull
    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @NonNull
    public Verb getRequestTokenVerb() {
        return Verb.POST;
    }

    public abstract String getRequestTokenEndpoint();

    public abstract String getAccessTokenEndpoint();

    public abstract String getAuthorizationUrl(Token var1);

    @Override
    @NonNull
    public OAuthService createService(@NonNull OAuthConfig config) {
        return new OAuth10aServiceImpl(this, config);
    }
}

