/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.kii.builder.api.DefaultApi20;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.model.Token;
import org.scribe.kii.model.Verb;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class ConstantContactApi2
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://oauth2.constantcontact.com/oauth2/oauth/siteowner/authorize?client_id=%s&response_type=code&redirect_uri=%s";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://oauth2.constantcontact.com/oauth2/oauth/token?grant_type=authorization_code";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull OAuthConfig config) {
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()));
    }

    @Override
    @NonNull
    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @Override
    @NonNull
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new AccessTokenExtractor(){

            @Override
            @NonNull
            public Token extract(@NonNull String response) {
                Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
                String regex = "\"access_token\"\\s*:\\s*\"([^&\"]+)\"";
                Matcher matcher = Pattern.compile(regex).matcher(response);
                if (matcher.find()) {
                    String token = OAuthEncoder.decode(matcher.group(1));
                    return new Token(token, "", response);
                }
                throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
            }
        };
    }
}

