/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder;

import android.support.annotation.NonNull;
import java.io.OutputStream;
import org.scribe.kii.builder.api.Api;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.model.SignatureType;
import org.scribe.kii.oauth.OAuthService;
import org.scribe.kii.utils.Preconditions;

public class ServiceBuilder {
    private String apiKey;
    private String apiSecret;
    private String callback = "oob";
    private Api api;
    private String scope;
    private SignatureType signatureType = SignatureType.Header;
    private OutputStream debugStream = null;

    @NonNull
    public ServiceBuilder provider(@NonNull Class<? extends Api> apiClass) {
        this.api = this.createApi(apiClass);
        return this;
    }

    private Api createApi(Class<? extends Api> apiClass) {
        Api api;
        Preconditions.checkNotNull(apiClass, "Api class cannot be null");
        try {
            api = apiClass.newInstance();
        }
        catch (Exception e) {
            throw new OAuthException("Error while creating the Api object", e);
        }
        return api;
    }

    @NonNull
    public ServiceBuilder provider(@NonNull Api api) {
        Preconditions.checkNotNull(api, "Api cannot be null");
        this.api = api;
        return this;
    }

    @NonNull
    public ServiceBuilder callback(@NonNull String callback) {
        Preconditions.checkNotNull(callback, "Callback can't be null");
        this.callback = callback;
        return this;
    }

    @NonNull
    public ServiceBuilder apiKey(@NonNull String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    @NonNull
    public ServiceBuilder apiSecret(@NonNull String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    @NonNull
    public ServiceBuilder scope(@NonNull String scope) {
        Preconditions.checkEmptyString(scope, "Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    @NonNull
    public ServiceBuilder signatureType(@NonNull SignatureType type) {
        Preconditions.checkNotNull((Object)type, "Signature type can't be null");
        this.signatureType = type;
        return this;
    }

    @NonNull
    public ServiceBuilder debugStream(@NonNull OutputStream stream) {
        Preconditions.checkNotNull(stream, "debug stream can't be null");
        this.debugStream = stream;
        return this;
    }

    @NonNull
    public ServiceBuilder debug() {
        this.debugStream(System.out);
        return this;
    }

    @NonNull
    public OAuthService build() {
        Preconditions.checkNotNull(this.api, "You must specify a valid api through the provider() method");
        Preconditions.checkEmptyString(this.apiKey, "You must provide an api key");
        Preconditions.checkEmptyString(this.apiSecret, "You must provide an api secret");
        return this.api.createService(new OAuthConfig(this.apiKey, this.apiSecret, this.callback, this.signatureType, this.scope, this.debugStream));
    }
}

